/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RefreshResourcesOperation
extends AbstractWorkingCopyOperation {
    public static int REFRESH_CACHE = 0;
    public static int REFRESH_CHANGES = 1;
    public static int REFRESH_ALL = 2;
    protected int depth;
    protected int refreshType;

    public RefreshResourcesOperation(IResource[] resources) {
        this(resources, 2, REFRESH_CHANGES);
    }

    public RefreshResourcesOperation(IResource[] resources, int depth, int refreshType) {
        super("Operation_RefreshResources", SVNMessages.class, resources);
        this.depth = depth;
        this.refreshType = refreshType;
    }

    public RefreshResourcesOperation(IResourceProvider provider) {
        this(provider, 2, REFRESH_CHANGES);
    }

    public RefreshResourcesOperation(IResourceProvider provider, int depth, int refreshType) {
        super("Operation_RefreshResources", SVNMessages.class, provider);
        this.depth = depth;
        this.refreshType = refreshType;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources;
        IResource[] original = this.operableData();
        IResource[] iResourceArray = resources = this.depth == 2 ? FileUtility.shrinkChildNodes(original) : original;
        if (this.refreshType != REFRESH_CACHE) {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < resources.length && !monitor.isCanceled()) {
                        ProgressMonitorUtility.setTaskInfo(monitor, RefreshResourcesOperation.this, resources[i].getName());
                        final IResource resource = resources[i];
                        RefreshResourcesOperation.this.protectStep(new IUnprotectedOperation(){

                            public void run(IProgressMonitor monitor) throws Exception {
                                if (SVNUtility.isPriorToSVN17()) {
                                    if (resource.getType() != 1 && (this).RefreshResourcesOperation.this.depth != 2) {
                                        RefreshResourcesOperation.this.refreshMetaInfo((IContainer)resource, monitor);
                                    }
                                    if (resource.getType() != 4) {
                                        RefreshResourcesOperation.this.refreshMetaInfo(resource.getParent(), monitor);
                                    }
                                }
                                RefreshResourcesOperation.this.doRefresh(resource, (this).RefreshResourcesOperation.this.depth, monitor);
                            }
                        }, monitor, resources.length);
                        ++i;
                    }
                }
            }, null, 1, monitor);
        }
        if (this.refreshType != REFRESH_CHANGES || !SVNUtility.isPriorToSVN17()) {
            SVNRemoteStorage.instance().refreshLocalResources(resources, this.depth);
            IResource[] roots = FileUtility.getPathNodes(resources);
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(roots, 0, 1));
            SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(original, this.depth, 0));
        }
    }

    protected void refreshMetaInfo(IContainer container, IProgressMonitor monitor) throws CoreException {
        IResource metaInfo = container.findMember(SVNUtility.getSVNFolderName());
        if (metaInfo != null) {
            this.doRefresh(metaInfo, 2, monitor);
        }
    }

    protected void doRefresh(IResource resource, int depth, IProgressMonitor monitor) throws CoreException {
        try {
            resource.refreshLocal(depth, monitor);
        }
        catch (CoreException ex) {
            if (ex.getStatus() != null && ex.getStatus().toString().indexOf("(.project)") != -1) {
                throw new UnreportableException(SVNMessages.Operation_RefreshResources_DamagedProjectFile);
            }
            throw ex;
        }
        FileUtility.findAndMarkSVNInternals(resource, true);
    }
}

