/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationChildEllipsisAssociation;
import org.eclipse.wb.internal.core.model.nonvisual.AbstractArrayObjectInfo;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EllipsisObjectInfo
extends AbstractArrayObjectInfo {
    public static final String ON_EMPTY_SOURCE_TAG = "arrayObject.OnEmptySource";
    private MethodInvocation m_invocation;
    private final int m_parameterIndex;
    private String m_onEmptySource;

    public EllipsisObjectInfo(AstEditor editor, String caption, Class<?> itemType, MethodInvocation invocation, int parameterIndex) throws Exception {
        super(editor, caption, itemType);
        this.m_invocation = invocation;
        this.m_parameterIndex = parameterIndex;
    }

    public void setInvocation(MethodInvocation invocation) {
        this.m_invocation = invocation;
    }

    public MethodInvocation getInvocation() {
        return this.m_invocation;
    }

    public int getParameterIndex() {
        return this.m_parameterIndex;
    }

    public void setOnEmptySource(String onEmptySource) {
        this.m_onEmptySource = onEmptySource;
    }

    public String getOnEmptySource() {
        return this.m_onEmptySource;
    }

    @Override
    protected Expression createItemExpression(JavaInfo item, int index, String source) throws Exception {
        return this.getEditor().addInvocationArgument(this.m_invocation, this.m_parameterIndex + index, source);
    }

    @Override
    protected Expression getMoveItemExpression(JavaInfo item, JavaInfo nextItem, AbstractArrayObjectInfo oldAbstractArrayInfo, int oldIndex, int newIndex) throws Exception {
        Expression element;
        if (oldAbstractArrayInfo instanceof EllipsisObjectInfo) {
            EllipsisObjectInfo oldEllipsisInfo = (EllipsisObjectInfo)oldAbstractArrayInfo;
            MethodInvocation oldInvocation = oldEllipsisInfo.getInvocation();
            if (oldInvocation.equals((Object)this.m_invocation)) {
                this.getParent().moveChild((ObjectInfo)item, (ObjectInfo)nextItem);
                this.m_items.remove((Object)item);
                this.m_items.add(newIndex, item);
                element = this.getEditor().moveInvocationArgument(oldInvocation, oldEllipsisInfo.getParameterIndex() + oldIndex, this.getParameterIndex() + newIndex);
            } else {
                element = this.moveFromEllipsis(item, nextItem, oldInvocation, oldEllipsisInfo, oldIndex, newIndex);
            }
        } else {
            element = this.moveOther(item, nextItem, newIndex);
        }
        return element;
    }

    private Expression moveFromEllipsis(JavaInfo item, JavaInfo nextItem, MethodInvocation oldInvocation, EllipsisObjectInfo oldEllipsisInfo, int oldIndex, int newIndex) throws Exception {
        AstEditor editor = this.getEditor();
        int oldInvocationIndex = oldEllipsisInfo.getParameterIndex() + oldIndex;
        String source = editor.getSource((ASTNode)DomGenerics.arguments(oldInvocation).get(oldInvocationIndex));
        Association association = item.getAssociation();
        if (association != null) {
            if (association.remove()) {
                item.setAssociation(null);
            }
        } else {
            editor.removeInvocationArgument(oldInvocation, oldInvocationIndex);
        }
        item.getParent().removeChild((ObjectInfo)item);
        this.getParent().addChild((ObjectInfo)item, (ObjectInfo)nextItem);
        this.addItem(newIndex, item);
        if (!(item.getVariableSupport() instanceof EmptyVariableSupport)) {
            item.getVariableSupport().ensureInstanceReadyAt(this.getStatementTarget());
            source = item.getVariableSupport().getReferenceExpression(this.getNodeTarget());
        }
        return this.getCreateItemExpression(item, newIndex, source);
    }

    @Override
    protected NodeTarget getNodeTarget() {
        return new NodeTarget(this.getStatementTarget());
    }

    @Override
    protected StatementTarget getStatementTarget() {
        return new StatementTarget(AstNodeUtils.getEnclosingStatement((ASTNode)this.m_invocation), true);
    }

    @Override
    protected Association getAssociation(Expression element) {
        return new InvocationChildEllipsisAssociation(this.m_invocation, this);
    }
}

