/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.wb.internal.core.nls.bundle.IPropertiesAccessor;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleInfo {
    private final IPropertiesAccessor m_propertiesAccessor;
    private final String m_bundleName;
    private final LocaleInfo m_locale;
    private final IFile m_file;
    private Map<String, String> m_properties;
    private long m_propertiesStamp;

    public static BundleInfo createBundle(IPropertiesAccessor propertiesAccessor, String bundleName, LocaleInfo localeInfo, IFile[] files) throws Exception {
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            if (localeInfo.equals(BundleInfo.getLocale(bundleName, file))) {
                return new BundleInfo(propertiesAccessor, bundleName, localeInfo, file);
            }
            ++i;
        }
        return null;
    }

    public static LocaleInfo getLocale(String bundleName, IFile file) {
        String shortBundleName = CodeUtils.getShortClass(bundleName);
        String localeName = file.getName();
        localeName = StringUtils.substring((String)localeName, (int)0, (int)(-".properties".length()));
        if ((localeName = localeName.substring(shortBundleName.length())).length() == 0) {
            return LocaleInfo.DEFAULT;
        }
        String localeDescription = "'" + localeName + "' for file '" + file + "'.";
        if (!localeName.startsWith("_")) {
            throw new IllegalArgumentException("'_' expected, but " + localeDescription);
        }
        localeName = localeName.substring(1);
        return LocaleInfo.create(localeName, localeDescription);
    }

    private BundleInfo(IPropertiesAccessor propertiesAccessor, String bundleName, LocaleInfo localeInfo, IFile file) throws Exception {
        this.m_propertiesAccessor = propertiesAccessor;
        this.m_bundleName = bundleName;
        this.m_file = file;
        this.m_locale = localeInfo;
        this.m_propertiesStamp = this.m_file.getModificationStamp();
    }

    public String getBundleName() {
        return this.m_bundleName;
    }

    public LocaleInfo getLocale() {
        return this.m_locale;
    }

    public IFile getFile() {
        return this.m_file;
    }

    public boolean isExternallyChanged() {
        return this.m_file.getModificationStamp() != this.m_propertiesStamp;
    }

    public Map<String, String> getMap() throws Exception {
        return new HashMap<String, String>(this.getProperties());
    }

    public void setMap(Map<String, String> map) {
        this.m_properties = new HashMap<String, String>(map);
    }

    private Map<String, String> getProperties() throws Exception {
        if (this.m_properties == null || this.isExternallyChanged()) {
            InputStream is = this.m_file.getContents(true);
            try {
                String charset = this.m_file.getCharset();
                this.m_properties = this.m_propertiesAccessor.load(is, charset);
            }
            finally {
                is.close();
            }
            this.m_propertiesStamp = this.m_file.getModificationStamp();
        }
        return this.m_properties;
    }

    public void save(String comments) throws Exception {
        if (this.m_properties != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String charset = this.m_file.getCharset();
            this.m_propertiesAccessor.save(baos, charset, this.m_properties, comments);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            this.m_file.setContents((InputStream)bais, true, true, null);
            this.m_propertiesStamp = this.m_file.getModificationStamp();
        }
    }

    public String getValue(String key) throws Exception {
        return this.getProperties().get(key);
    }

    public void setValue(String key, String value) throws Exception {
        Map<String, String> properties = this.getProperties();
        if (value.length() == 0) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    public void replaceKey(String oldKey, String newKey, boolean keepOldValue) throws Exception {
        if (keepOldValue && this.containsKey(newKey)) {
            this.removeKey(oldKey);
        } else {
            Map<String, String> properties = this.getProperties();
            String value = properties.get(oldKey);
            properties.remove(oldKey);
            this.setValue(newKey, value);
        }
    }

    public Set<String> getKeys() throws Exception {
        return this.getProperties().keySet();
    }

    public boolean containsKey(String key) throws Exception {
        return this.getProperties().containsKey(key);
    }

    public void removeKey(String key) throws Exception {
        this.getProperties().remove(key);
    }
}

