/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.trace.FileBasedTraceInformation;
import org.eclipse.xtext.builder.trace.TraceMarkers;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.SmapSupport;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.util.StringInputStream;

public class EclipseResourceFileSystemAccess2
extends AbstractFileSystemAccess {
    private static final Logger log = Logger.getLogger(EclipseResourceFileSystemAccess2.class);
    private IProject project;
    private IProgressMonitor monitor;
    private IFileCallback callBack;
    @Inject
    private TraceRegionSerializer traceSerializer;
    @Inject
    private TraceMarkers traceMarkers;
    @Inject
    private FileBasedTraceInformation fileBasedTraceInformation;
    @Inject
    private IWorkspace workspace;
    private Multimap<URI, IPath> sourceTraces;
    @Inject
    private SmapSupport smapSupport;

    protected IFileCallback getCallBack() {
        return this.callBack;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setPostProcessor(IFileCallback callBack) {
        this.callBack = callBack;
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void generateFile(String fileName, String outputName, CharSequence contents) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        OutputConfiguration outputConfig = this.getOutputConfig(outputName);
        IFolder folder = this.getFolder(outputConfig);
        if (!folder.exists()) {
            if (outputConfig.isCreateOutputDirectory()) {
                try {
                    this.createFolder(folder);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            } else {
                return;
            }
        }
        IFile file = this.getFile(fileName, outputName);
        IFile traceFile = this.getTraceFile(file);
        IFile smapFile = this.getSmapFile(file);
        CharSequence postProcessedContent = this.postProcess(fileName, outputName, contents);
        String contentsAsString = postProcessedContent.toString();
        if (file.exists()) {
            if (outputConfig.isOverrideExistingResources()) {
                try {
                    StringInputStream newContent = this.getInputStream(contentsAsString, this.getEncoding(file));
                    if (this.hasContentsChanged(file, newContent)) {
                        newContent.reset();
                        file.setContents((InputStream)newContent, true, true, this.monitor);
                        if (file.isDerived() != outputConfig.isSetDerivedProperty()) {
                            this.setDerived(file, outputConfig.isSetDerivedProperty());
                        }
                    } else if (smapFile != null) {
                        file.touch(this.monitor);
                    }
                    if (smapFile != null) {
                        this.updateSmapInformation(smapFile, postProcessedContent, file);
                    }
                    this.updateTraceInformation(traceFile, postProcessedContent, outputConfig.isSetDerivedProperty());
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (this.callBack != null) {
                    this.callBack.afterFileUpdate(file);
                }
            }
        } else {
            try {
                this.ensureParentExists(file);
                file.create((InputStream)this.getInputStream(contentsAsString, this.getEncoding(file)), true, this.monitor);
                if (outputConfig.isSetDerivedProperty()) {
                    this.setDerived(file, true);
                }
                this.updateTraceInformation(traceFile, postProcessedContent, outputConfig.isSetDerivedProperty());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.callBack != null) {
                this.callBack.afterFileCreation(file);
            }
        }
    }

    protected String getEncoding(IFile file) throws CoreException {
        return file.getCharset(true);
    }

    protected void setDerived(IFile file, boolean derived) throws CoreException {
        file.setDerived(derived);
    }

    protected void createFolder(IFolder folder) throws CoreException {
        this.ensureExists((IContainer)folder);
    }

    protected void ensureParentExists(IFile file) throws CoreException {
        if (!file.exists()) {
            this.ensureExists(file.getParent());
        }
    }

    protected void ensureExists(IContainer container) throws CoreException {
        if (container.exists()) {
            return;
        }
        if (container instanceof IFolder) {
            this.ensureExists(container.getParent());
            ((IFolder)container).create(true, true, this.monitor);
        }
    }

    protected StringInputStream getInputStream(String contentsAsString, String encoding) {
        try {
            return new StringInputStream(contentsAsString, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected IFolder getFolder(OutputConfiguration outputConfig) {
        return this.project.getFolder((IPath)new Path(outputConfig.getOutputDirectory()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasContentsChanged(IFile file, StringInputStream newContent) {
        boolean contentChanged = false;
        BufferedInputStream oldContent = null;
        try {
            try {
                oldContent = new BufferedInputStream(file.getContents());
                int newByte = newContent.read();
                int oldByte = oldContent.read();
                while (newByte != -1 && oldByte != -1 && newByte == oldByte) {
                    newByte = newContent.read();
                    oldByte = oldContent.read();
                }
                contentChanged = newByte != oldByte;
                return contentChanged;
            }
            catch (CoreException e) {
                contentChanged = true;
                if (oldContent == null) return contentChanged;
                try {
                    oldContent.close();
                    return contentChanged;
                }
                catch (IOException iOException) {}
                return contentChanged;
            }
            catch (IOException e) {
                contentChanged = true;
                if (oldContent == null) return contentChanged;
                try {
                    oldContent.close();
                    return contentChanged;
                }
                catch (IOException iOException) {}
                return contentChanged;
            }
        }
        finally {
            if (oldContent != null) {
                try {
                    oldContent.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void updateTraceInformation(IFile traceFile, CharSequence contents, boolean derived) throws CoreException, IOException {
        if (contents instanceof ITraceRegionProvider) {
            AbstractTraceRegion traceRegion = ((ITraceRegionProvider)contents).getTraceRegion();
            if (this.sourceTraces == null) {
                this.sourceTraces = HashMultimap.create();
            }
            IPath tracePath = traceFile.getFullPath();
            TreeIterator iterator = traceRegion.treeIterator();
            while (iterator.hasNext()) {
                AbstractTraceRegion region = (AbstractTraceRegion)iterator.next();
                for (ILocationData location : region.getAssociatedLocations()) {
                    URI path = location.getPath();
                    if (path == null) continue;
                    this.sourceTraces.put((Object)path, (Object)tracePath);
                }
            }
            class AccessibleOutputStream
            extends ByteArrayOutputStream {
                AccessibleOutputStream() {
                }

                byte[] internalBuffer() {
                    return this.buf;
                }

                int internalLength() {
                    return this.count;
                }
            }
            AccessibleOutputStream data = new AccessibleOutputStream();
            this.traceSerializer.writeTraceRegionTo(traceRegion, (OutputStream)data);
            ByteArrayInputStream input = new ByteArrayInputStream(data.internalBuffer(), 0, data.internalLength());
            if (traceFile.exists()) {
                traceFile.setContents((InputStream)input, false, true, this.monitor);
            } else {
                traceFile.create((InputStream)input, true, this.monitor);
            }
            this.setDerived(traceFile, derived);
            return;
        }
        if (traceFile.exists()) {
            traceFile.delete(2, this.monitor);
        }
    }

    protected IFile getSmapFile(IFile javaSourceFile) {
        if (!javaSourceFile.getName().endsWith(".java")) {
            return null;
        }
        IContainer folder = javaSourceFile.getParent();
        IFile file = folder.getFile((IPath)new Path(javaSourceFile.getName().replace(".java", ".smap")));
        return file;
    }

    protected void updateSmapInformation(IFile smapFile, CharSequence postProcessedContent, IFile javaSource) {
        if (!(postProcessedContent instanceof ITraceRegionProvider)) {
            return;
        }
        AbstractTraceRegion traceRegion = ((ITraceRegionProvider)postProcessedContent).getTraceRegion();
        String smap = this.smapSupport.generateSmap(traceRegion, javaSource.getName());
        try {
            if (smap == null) {
                if (smapFile.exists()) {
                    smapFile.delete(true, null);
                }
            } else {
                StringInputStream smapAsStream = new StringInputStream(smap);
                if (!smapFile.exists()) {
                    smapFile.create((InputStream)smapAsStream, true, this.monitor);
                } else {
                    smapFile.setContents((InputStream)smapAsStream, true, true, this.monitor);
                }
            }
        }
        catch (CoreException e) {
            log.error((Object)e);
        }
    }

    public void flushSourceTraces() throws CoreException {
        this.flushSourceTraces("default");
    }

    public void flushSourceTraces(String generatorName) throws CoreException {
        if (this.sourceTraces != null) {
            Set keys = this.sourceTraces.keySet();
            for (URI uri : keys) {
                if (!uri.isPlatformResource()) continue;
                Collection paths = this.sourceTraces.get((Object)uri);
                IFile sourceFile = this.workspace.getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                if (!sourceFile.exists()) continue;
                IPath[] tracePathArray = paths.toArray(new IPath[paths.size()]);
                this.traceMarkers.installMarker(sourceFile, generatorName, tracePathArray);
            }
        }
        this.sourceTraces = null;
    }

    protected IFile getTraceFile(IFile file) {
        IStorage traceFile = this.fileBasedTraceInformation.getTraceFile((IStorage)file);
        if (traceFile instanceof IFile) {
            return (IFile)traceFile;
        }
        return null;
    }

    public void deleteFile(String fileName, String outputName) {
        try {
            IFile file = this.getFile(fileName, outputName);
            this.deleteFile(file, this.monitor);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IFileCallback callBack = this.getCallBack();
        if ((callBack == null || callBack.beforeFileDeletion(file)) && file.exists()) {
            IFile traceFile = this.getTraceFile(file);
            file.delete(2, monitor);
            if (traceFile.exists()) {
                traceFile.delete(2, monitor);
            }
        }
    }

    protected IFile getFile(String fileName, String outputName) {
        OutputConfiguration configuration = this.getOutputConfig(outputName);
        IFolder folder = this.getFolder(configuration);
        return folder.getFile((IPath)new Path(fileName));
    }

    public URI getURI(String fileName, String outputConfiguration) {
        IFile file = this.getFile(fileName, outputConfiguration);
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public static interface IFileCallback {
        public void afterFileUpdate(IFile var1);

        public void afterFileCreation(IFile var1);

        public boolean beforeFileDeletion(IFile var1);
    }
}

