/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.xml.client;

import com.google.gwt.xml.client.CDATASection;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.Text;
import com.google.gwt.xml.client.impl.XMLParserImpl;
import java.util.ArrayList;

public class XMLParser {
    private static final XMLParserImpl impl = XMLParserImpl.getInstance();

    public static Document createDocument() {
        return impl.createDocument();
    }

    public static Document parse(String contents) {
        return impl.parse(contents);
    }

    public static void removeWhitespace(Node n) {
        XMLParser.removeWhitespaceInner(n, null);
    }

    public static boolean supportsCDATASection() {
        return impl.supportsCDATASection();
    }

    private static void removeWhitespaceInner(Node n, Node parent) {
        Text t;
        if (parent != null && n instanceof Text && !(n instanceof CDATASection) && (t = (Text)n).getData().matches("[ \t\n]*")) {
            parent.removeChild(t);
        }
        if (n.hasChildNodes()) {
            int length = n.getChildNodes().getLength();
            ArrayList<Node> toBeProcessed = new ArrayList<Node>();
            for (int i = 0; i < length; ++i) {
                toBeProcessed.add(n.getChildNodes().item(i));
            }
            for (Node childNode : toBeProcessed) {
                XMLParser.removeWhitespaceInner(childNode, n);
            }
        }
    }

    private XMLParser() {
    }
}

