/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;

public abstract class AbstractCharCollection
implements CharCollection {
    @Override
    public abstract CharIterator iterator();

    @Override
    public abstract int size();

    protected AbstractCharCollection() {
    }

    @Override
    public boolean add(char element) {
        throw new UnsupportedOperationException("add(char) is not supported.");
    }

    @Override
    public boolean addAll(CharCollection c) {
        boolean modified = false;
        CharIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean contains(char element) {
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(CharCollection c) {
        CharIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeElement(char element) {
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(CharCollection c) {
        boolean modified = false;
        CharIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    @Override
    public boolean retainAll(CharCollection c) {
        boolean modified = false;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public char[] toArray() {
        char[] array = new char[this.size()];
        int i = 0;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public char[] toArray(char[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

