/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.RandomAccessShortList;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortList;

public class ArrayShortList
extends RandomAccessShortList
implements ShortList,
Serializable {
    private transient short[] _data = null;
    private int _size = 0;

    public ArrayShortList() {
        this(8);
    }

    public ArrayShortList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new short[initialCapacity];
        this._size = 0;
    }

    public ArrayShortList(ShortCollection that) {
        this(that.size());
        this.addAll(that);
    }

    @Override
    public short get(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public short removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        short oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    @Override
    public short set(int index, short element) {
        this.checkRange(index);
        this.incrModCount();
        short oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    @Override
    public void add(int index, short element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            short[] olddata = this._data;
            this._data = new short[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            short[] olddata = this._data;
            this._data = new short[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeShort(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new short[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readShort();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

