/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.RandomAccessLongList;

public class ArrayUnsignedIntList
extends RandomAccessLongList
implements LongList,
Serializable {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private transient int[] _data = null;
    private int _size = 0;

    public ArrayUnsignedIntList() {
        this(8);
    }

    public ArrayUnsignedIntList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new int[initialCapacity];
        this._size = 0;
    }

    public ArrayUnsignedIntList(LongCollection that) {
        this(that.size());
        this.addAll(that);
    }

    @Override
    public long get(int index) {
        this.checkRange(index);
        return this.toLong(this._data[index]);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public long removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        long oldval = this.toLong(this._data[index]);
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    @Override
    public long set(int index, long element) {
        this.assertValidUnsignedInt(element);
        this.checkRange(index);
        this.incrModCount();
        long oldval = this.toLong(this._data[index]);
        this._data[index] = this.fromLong(element);
        return oldval;
    }

    @Override
    public void add(int index, long element) {
        this.assertValidUnsignedInt(element);
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = this.fromLong(element);
        ++this._size;
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            int[] olddata = this._data;
            this._data = new int[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            int[] olddata = this._data;
            this._data = new int[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private final long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private final int fromLong(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    private final void assertValidUnsignedInt(long value) throws IllegalArgumentException {
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.valueOf(value) + " > " + 0xFFFFFFFFL);
        }
        if (value < 0L) {
            throw new IllegalArgumentException(String.valueOf(value) + " < " + 0L);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeInt(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new int[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readInt();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

