/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.AbstractByteCollection;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.ByteListIterator;

public abstract class RandomAccessByteList
extends AbstractByteCollection
implements ByteList {
    private int _modCount = 0;

    protected RandomAccessByteList() {
    }

    @Override
    public abstract byte get(int var1);

    @Override
    public abstract int size();

    @Override
    public byte removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte set(int index, byte element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, byte element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(byte element) {
        this.add(this.size(), element);
        return true;
    }

    @Override
    public boolean addAll(int index, ByteCollection collection) {
        boolean modified = false;
        ByteIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            modified = true;
        }
        return modified;
    }

    @Override
    public int indexOf(byte element) {
        int i = 0;
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte element) {
        ByteListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != element) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    @Override
    public ByteIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ByteListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ByteListIterator listIterator(int index) {
        return new RandomAccessByteListIterator(this, index);
    }

    @Override
    public ByteList subList(int fromIndex, int toIndex) {
        return new RandomAccessByteSubList(this, fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof ByteList) {
            ByteList thatList = (ByteList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            ByteIterator thatIter = thatList.iterator();
            ByteIterator thisIter = this.iterator();
            while (thisIter.hasNext()) {
                if (thisIter.next() == thatIter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 1;
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            hash = 31 * hash + iter.next();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    private static class ComodChecker {
        private RandomAccessByteList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessByteList source) {
            this._source = source;
            this.resyncModCount();
        }

        protected RandomAccessByteList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }

    protected static class RandomAccessByteListIterator
    extends ComodChecker
    implements ByteListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessByteListIterator(RandomAccessByteList list, int index) {
            super(list);
            if (index < 0 || index > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + index + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = index;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public byte next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte val = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return val;
        }

        @Override
        public byte previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            byte val = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return val;
        }

        @Override
        public void add(byte value) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, value);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().removeElementAt(this._lastReturnedIndex);
            this._lastReturnedIndex = -1;
            --this._nextIndex;
            this.resyncModCount();
        }

        @Override
        public void set(byte value) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, value);
            this.resyncModCount();
        }
    }

    protected static class RandomAccessByteSubList
    extends RandomAccessByteList
    implements ByteList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessByteList _list = null;
        private ComodChecker _comod = null;

        RandomAccessByteSubList(RandomAccessByteList list, int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._offset = fromIndex;
            this._limit = toIndex - fromIndex;
            this._comod = new ComodChecker(list);
            this._comod.resyncModCount();
        }

        @Override
        public byte get(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(index));
        }

        @Override
        public byte removeElementAt(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            byte val = this._list.removeElementAt(this.toUnderlyingIndex(index));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return val;
        }

        @Override
        public byte set(int index, byte element) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            byte val = this._list.set(this.toUnderlyingIndex(index), element);
            this.incrModCount();
            this._comod.resyncModCount();
            return val;
        }

        @Override
        public void add(int index, byte element) {
            this.checkRangeIncludingEndpoint(index);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(index), element);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int index) {
            return index + this._offset;
        }
    }
}

