/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.FloatEncoder;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.payloads.IntegerEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedPayloadTokenFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    public static final String ENCODER_ATTR = "encoder";
    public static final String DELIMITER_ATTR = "delimiter";
    private PayloadEncoder encoder;
    private char delimiter = (char)124;

    public DelimitedPayloadTokenFilter create(TokenStream input) {
        return new DelimitedPayloadTokenFilter(input, this.delimiter, this.encoder);
    }

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
    }

    @Override
    public void inform(ResourceLoader loader) {
        String encoderClass = (String)this.args.get(ENCODER_ATTR);
        this.encoder = encoderClass.equals("float") ? new FloatEncoder() : (encoderClass.equals("integer") ? new IntegerEncoder() : (encoderClass.equals("identity") ? new IdentityEncoder() : (PayloadEncoder)loader.newInstance(encoderClass, new String[0])));
        String delim = (String)this.args.get(DELIMITER_ATTR);
        if (delim != null) {
            if (delim.length() == 1) {
                this.delimiter = delim.charAt(0);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Delimiter must be one character only");
            }
        }
    }
}

