/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IValue;
import org.metaabm.MetaABMPackage;
import org.metaabm.act.AInput;
import org.metaabm.act.AMultiValue;
import org.metaabm.act.ASink;
import org.metaabm.commands.MultiValueCommand;
import org.metaabm.commands.SetLabelCommand;

public class SetSinkLabelCommand
extends MultiValueCommand {
    String newSinkName;

    public SetSinkLabelCommand(EditingDomain domain, ASink sink, String newName) {
        super(domain, sink, sink.getFunction());
        this.newSinkName = newName;
        if (this.function != null && this.function.isMultiValue()) {
            int index = 0;
            for (AInput input : sink.getInputs()) {
                if (index > 0) {
                    this.replaceMultiValuesName(input, index);
                }
                ++index;
            }
        }
    }

    protected void replaceMultiValuesName(AInput input, int index) {
        if (input.getValue() instanceof AMultiValue) {
            AMultiValue multiValue = (AMultiValue)input.getValue();
            String newValueName = StringUtils.replace((String)multiValue.getLabel(), (String)this.sink.getLabel(), (String)this.newSinkName);
            this.append((Command)new SetLabelCommand(this.domain, (EObject)multiValue, (EStructuralFeature)MetaABMPackage.Literals.IID__LABEL, newValueName, 0));
            for (IValue option : multiValue.getValues()) {
                String newOptionName = StringUtils.replace((String)option.getLabel(), (String)this.sink.getLabel(), (String)this.newSinkName);
                this.append((Command)new SetLabelCommand(this.domain, (EObject)option, (EStructuralFeature)MetaABMPackage.Literals.IID__LABEL, newOptionName, 0));
            }
        }
    }
}

