/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.lib.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.internal.lib.commands.SetCurrentEditModelCommand;
import org.eclipse.birt.report.designer.internal.lib.editparts.EmptyEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.ReportDesignMarginBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicsViewModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportDesignEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportRootFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.AbstractPageFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportDesignLayout;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.widgets.Display;

public class LibraryReportDesignEditPart
extends ReportDesignEditPart
implements PropertyChangeListener {
    private static final Insets INSETS = new Insets(30, 30, 30, 30);
    private static final Dimension DEFAULTSIZE = new Dimension(800, 1000);

    public LibraryReportDesignEditPart(Object obj) {
        super(obj);
    }

    protected IFigure createFigure() {
        ReportRootFigure figure = new ReportRootFigure();
        figure.setOpaque(true);
        figure.setShowMargin(this.showMargin);
        ReportDesignLayout layout = new ReportDesignLayout((GraphicalEditPart)this);
        Dimension size = DEFAULTSIZE;
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        layout.setInitSize(bounds);
        figure.setLayoutManager((LayoutManager)layout);
        ReportDesignMarginBorder border = new ReportDesignMarginBorder(INSETS);
        border.reInitStyle();
        figure.setBorder((Border)border);
        figure.setBounds(bounds.getCopy());
        return figure;
    }

    protected List getModelChildren() {
        return HandleAdapterFactory.getInstance().getLibraryHandleAdapter(this.getModel()).getChildren();
    }

    public void refreshFigure() {
        ReportRootFigure figure = (ReportRootFigure)this.getFigure();
        figure.setShowMargin(this.showMargin);
        Dimension size = DEFAULTSIZE;
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitSize(bounds);
        ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitInsets(INSETS);
    }

    public void activate() {
        HandleAdapterFactory.getInstance().getLibraryHandleAdapter(this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        super.activate();
    }

    public void deactivate() {
        HandleAdapterFactory.getInstance().getLibraryHandleAdapter(this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        if ("current model".equals(evt.getPropertyName()) || "create element".equals(evt.getPropertyName())) {
            this.refresh();
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    Object model = evt.getNewValue();
                    Object editpart = LibraryReportDesignEditPart.this.getViewer().getEditPartRegistry().get(model);
                    if (editpart instanceof EditPart) {
                        LibraryReportDesignEditPart.this.getViewer().flush();
                        if (!(editpart instanceof EmptyEditPart)) {
                            LibraryReportDesignEditPart.this.getViewer().select((EditPart)editpart);
                        }
                    }
                    if (editpart != null) {
                        Request request;
                        LibraryReportDesignEditPart.this.getViewer().reveal((EditPart)editpart);
                        if ("create element".equals(evt.getPropertyName()) && ((EditPart)editpart).understandsRequest(request = new Request((Object)"create element"))) {
                            ((EditPart)editpart).performRequest(request);
                        }
                    }
                }
            });
        }
    }

    private boolean isModelInModuleHandle() {
        List list = this.getModelChildren();
        int size = list.size();
        int i = 0;
        while (i < size) {
            DesignElementHandle handle;
            Object obj = list.get(i);
            if (obj instanceof DesignElementHandle && (handle = (DesignElementHandle)obj).getRoot() == null && !this.getChildren().isEmpty() && ((EditPart)this.getChildren().get(0)).getModel().equals(handle)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                CreateCommand command = new CreateCommand(request.getExtendedData());
                Object model = this.getHost().getModel();
                if (model instanceof SlotHandle) {
                    command.setParent(model);
                } else if (model instanceof ListBandProxy) {
                    command.setParent((Object)((ListBandProxy)model).getSlotHandle());
                } else {
                    command.setParent(model);
                }
                return command;
            }
        });
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
    }

    protected void notifyModelChange(Object focus) {
        super.notifyModelChange(focus);
        if (!this.isModelInModuleHandle()) {
            SetCurrentEditModelCommand command = new SetCurrentEditModelCommand(null);
            command.execute();
        }
    }

    public Object getAdapter(Class key) {
        if (key == IModelEventProcessor.class) {
            return new GraphicsViewModelEventProcessor((AbstractModelEventProcessor.IModelEventFactory)this){

                public void clear() {
                    super.clear();
                    Object oldObj = HandleAdapterFactory.getInstance().getLibraryHandleAdapter().getOldEditorModel();
                    SetCurrentEditModelCommand c = new SetCurrentEditModelCommand(oldObj);
                    Object obj = HandleAdapterFactory.getInstance().getLibraryHandleAdapter().getCurrentEditorModel();
                    if (obj instanceof DesignElementHandle && ((DesignElementHandle)obj).getContainer() != null) {
                        c = new SetCurrentEditModelCommand(obj);
                    } else if (oldObj instanceof DesignElementHandle && ((DesignElementHandle)oldObj).getContainer() == null) {
                        c = new SetCurrentEditModelCommand(null);
                    }
                    c.execute();
                }
            };
        }
        return super.getAdapter(key);
    }

    protected void updateLayoutPreference() {
    }

    public void refreshMarginBorder(ReportDesignMarginBorder border) {
        border.reInitStyle();
        this.getFigure().setBorder((Border)border);
    }
}

