/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.DeleteLinkCommand;
import org.eclipse.bpel.ui.commands.DeletePartnerLinkTypeCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.Definition;

public class DeleteChildCommand
extends AutoUndoCommand {
    private EObject fChild;
    private EObject fParent;
    IContainer fContainer;
    Resource[] resourcesToModify = null;
    CompoundCommand fDeleteLinksCmd;
    CompoundCommand fDeletePLTsCmd;

    public DeleteChildCommand(EObject child) {
        super(new ArrayList<Object>(2));
        IContainer container;
        List<EObject> children;
        this.fParent = child.eContainer();
        if ((this.fParent instanceof FaultHandler || this.fParent instanceof EventHandler) && (children = (container = BPELUtil.adapt((Object)this.fParent, IContainer.class)).getChildren(this.fParent)).size() == 1 && children.contains(child)) {
            child = this.fParent;
            this.fParent = child.eContainer();
        }
        this.fChild = child;
        if (this.fParent != null) {
            this.addModelRoot(this.fParent);
        }
        this.fContainer = BPELUtil.adapt((Object)this.fParent, IContainer.class);
        String childType = null;
        ILabeledElement labeledElement = BPELUtil.adapt((Object)child, ILabeledElement.class);
        if (labeledElement != null) {
            childType = labeledElement.getTypeLabel(child);
        }
        if (childType == null) {
            childType = Messages.DeleteChildCommand_Item_1;
        }
        this.setLabel(NLS.bind((String)Messages.DeleteChildCommand_Delete_2, (Object[])new Object[]{childType}));
    }

    @Override
    public boolean canDoExecute() {
        if (this.fChild == null || this.fParent == null || this.fContainer == null) {
            return false;
        }
        return this.fContainer.canRemoveChild(this.fParent, this.fChild);
    }

    @Override
    public Resource[] getResources() {
        if (this.resourcesToModify == null) {
            Process process = BPELUtils.getProcess((Object)this.fParent);
            if (process == null) {
                return EMPTY_RESOURCE_ARRAY;
            }
            BPELEditor bpelEditor = ModelHelper.getBPELEditor(process);
            HashSet<Resource> resultSet = new HashSet<Resource>();
            resultSet.add(this.fParent.eResource());
            HashSet<Object> deletingSet = new HashSet<Object>();
            ModelHelper.addSubtreeToCollection(this.fChild, deletingSet);
            HashSet<PartnerLinkType> partnerLinkTypes = null;
            Definition artifactsDefinition = bpelEditor.getArtifactsDefinition();
            for (Object object : deletingSet) {
                PartnerLinkType plt;
                if (!(object instanceof PartnerLink) || (plt = ((PartnerLink)object).getPartnerLinkType()) == null || plt.getEnclosingDefinition() != artifactsDefinition) continue;
                if (partnerLinkTypes == null) {
                    partnerLinkTypes = new HashSet<PartnerLinkType>();
                }
                if (!partnerLinkTypes.add(plt)) continue;
                resultSet.add(plt.eResource());
            }
            this.resourcesToModify = resultSet.toArray(new Resource[resultSet.size()]);
        }
        return this.resourcesToModify;
    }

    @Override
    public void doExecute() {
        if (!this.canExecute()) {
            throw new IllegalStateException();
        }
        Process process = BPELUtils.getProcess((Object)this.fParent);
        if (process == null) {
            return;
        }
        BPELEditor bpelEditor = ModelHelper.getBPELEditor(process);
        Process topModelObject = process;
        if (this.fChild.eResource() == null) {
            return;
        }
        HashSet<Object> deletingSet = new HashSet<Object>();
        ModelHelper.addSubtreeToCollection(this.fChild, deletingSet);
        HashSet<PartnerLinkType> partnerLinkTypes = null;
        Definition artifactsDefinition = bpelEditor.getArtifactsDefinition();
        for (Object object : deletingSet) {
            PartnerLinkType plt;
            if (!(object instanceof PartnerLink) || (plt = ((PartnerLink)object).getPartnerLinkType()) == null || plt.getEnclosingDefinition() != artifactsDefinition || !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DeletePartnerLinkTypeWarningDialogTitle, (String)NLS.bind((String)Messages.DeletePartnerLinkTypeWarningMessage, (Object[])new Object[]{((PartnerLink)object).getName(), plt.getName()}))) continue;
            if (partnerLinkTypes == null) {
                partnerLinkTypes = new HashSet<PartnerLinkType>();
            }
            if (!partnerLinkTypes.add(plt)) continue;
            if (this.fDeletePLTsCmd == null) {
                this.fDeletePLTsCmd = new CompoundCommand();
            }
            this.fDeletePLTsCmd.add((Command)new DeletePartnerLinkTypeCommand(plt));
        }
        HashSet<Object> notDeletingSet = new HashSet<Object>();
        ModelHelper.addSubtreeToCollection(topModelObject, notDeletingSet);
        notDeletingSet.removeAll(deletingSet);
        HashSet<Flow> flowSet = new HashSet<Flow>();
        Iterator<Object> it = deletingSet.iterator();
        while (it.hasNext()) {
            Flow[] flws = FlowLinkUtil.getParentFlows((EObject)it.next());
            flowSet.addAll(Arrays.asList(flws));
        }
        flowSet.removeAll(deletingSet);
        this.fDeleteLinksCmd = new CompoundCommand();
        for (Flow flow : flowSet) {
            for (Link link : FlowLinkUtil.getFlowLinks(flow)) {
                DeleteLinkCommand child;
                if (!deletingSet.contains(FlowLinkUtil.getLinkSource(link)) && !deletingSet.contains(FlowLinkUtil.getLinkTarget(link)) || !(child = new DeleteLinkCommand(link)).canExecute()) continue;
                this.fDeleteLinksCmd.add((Command)child);
            }
        }
        this.fDeleteLinksCmd.doExecute();
        if (this.fDeletePLTsCmd != null) {
            this.fDeletePLTsCmd.doExecute();
        }
        this.fContainer.removeChild(this.fParent, this.fChild);
        it = notDeletingSet.iterator();
        while (it.hasNext()) {
            BPELUtil.deleteNonContainmentRefs((EObject)it.next(), deletingSet);
        }
    }
}

