/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.dialogs.EditMessagePropertyDialog;
import org.eclipse.bpel.ui.dialogs.SelectionAndCreationDialog;
import org.eclipse.bpel.ui.properties.PropertiesLabelProvider;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class PropertySelectorDialog
extends SelectionAndCreationDialog {
    protected CorrelationSet correlationSet;
    protected Text filterText;
    protected Table lowerList;
    protected TabbedPropertySheetWidgetFactory wf;

    public PropertySelectorDialog(Shell parent, CorrelationSet correlationSet, TabbedPropertySheetWidgetFactory wf) {
        super(parent, (ILabelProvider)new PropertiesLabelProvider(), (ILabelProvider)new TypeLabelProvider());
        this.setTitle(Messages.PropertySelectorDialog_Select_a_Property_2);
        this.correlationSet = correlationSet;
        this.wf = wf;
        this.setMessage(Messages.PropertySelectorDialog_Property_Name_wildcards_3);
        this.setUpperListLabel(Messages.PropertySelectorDialog_Matches_4);
        this.setLowerListLabel(Messages.PropertySelectorDialog_Property_Type_5);
        this.refreshProperties();
    }

    protected void refreshProperties() {
        Process process = BPELUtils.getProcess((Object)this.correlationSet);
        Set<Property> properties = ModelHelper.getAvailableProperties(process);
        Iterator iter = this.correlationSet.getProperties().iterator();
        while (iter.hasNext()) {
            properties.remove(iter.next());
        }
        Object[] propertiesArray = properties.toArray(new Property[properties.size()]);
        this.setElements(propertiesArray);
        if (this.fFilteredList != null) {
            this.setListElements(propertiesArray);
        }
        if (propertiesArray.length > 0 && this.fFilteredList != null) {
            this.filterText.setEnabled(true);
            this.lowerList.setEnabled(true);
            this.fFilteredList.setEnabled(true);
        }
    }

    @Override
    protected void handleNewButtonPushed() {
        Property property;
        Process process = BPELUtils.getProcess((Object)this.correlationSet);
        BPELEditor bpelEditor = ModelHelper.getBPELEditor(process);
        String newName = this.filterText.getText();
        EditMessagePropertyDialog dialog = new EditMessagePropertyDialog(this.getShell(), null, newName, bpelEditor, this.wf);
        if (dialog.open() == 0 && (property = dialog.getProperty()) != null) {
            this.refreshProperties();
            this.setFilter(property.getName());
            this.setLowerSelectedElement(property);
            this.getOkButton().setFocus();
        }
    }

    public Property getProperty() {
        if (this.getResult().length > 0) {
            return (Property)this.getResult()[0];
        }
        return null;
    }

    @Override
    protected Text createFilterText(Composite parent) {
        this.filterText = super.createFilterText(parent);
        return this.filterText;
    }

    protected Table createLowerList(Composite parent) {
        this.lowerList = super.createLowerList(parent);
        return this.lowerList;
    }

    protected static class TypeLabelProvider
    extends LabelProvider {
        protected TypeLabelProvider() {
        }

        public String getText(Object element) {
            Property property;
            Object type;
            if (element instanceof Property && (type = (property = (Property)element).getType()) != null) {
                if (type instanceof XSDTypeDefinition) {
                    XSDTypeDefinition typeDefinition = (XSDTypeDefinition)type;
                    return typeDefinition.getName();
                }
                if (type instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdElement = (XSDElementDeclaration)type;
                    return xsdElement.getName();
                }
            }
            return Messages.PropertySelectorDialog_None_1;
        }
    }
}

