/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text.completion;

import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.text.completion.HTMLPrinter;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;

public class TclKeywordLazyContextInformation
implements IContextInformation,
IContextInformationExtension {
    private final ICompletionProposal proposal;
    private final String target;
    private final ISourceModule module;
    private boolean informationComputed = false;
    private String information;
    private static final String EMPTY = "";
    private static final Pattern EOL = Pattern.compile("[\r\n]+");
    private static final Pattern HEADER = Pattern.compile("<h\\d>(.*?)</h\\d>", 2);
    private static final String SYNOPSIS = "SYNOPSIS";
    private static final Pattern CUT_HTML_TAGS = Pattern.compile("<[^>]+>");

    public TclKeywordLazyContextInformation(ICompletionProposal proposal, String target, ISourceModule module) {
        this.proposal = proposal;
        this.target = TclKeywordLazyContextInformation.removeColons(target);
        this.module = module;
    }

    private static String removeColons(String s) {
        int i = 0;
        while (i < s.length() && s.charAt(i) == ':') {
            ++i;
        }
        return s.substring(i);
    }

    public String getContextDisplayString() {
        return this.proposal.getDisplayString();
    }

    public Image getImage() {
        return null;
    }

    public String getInformationDisplayString() {
        if (!this.informationComputed) {
            this.informationComputed = true;
            this.information = this.computeInformation();
        }
        return this.information;
    }

    private String getInfo() {
        try {
            Reader reader = ScriptDocumentationAccess.getKeywordDocumentation((String)"org.eclipse.dltk.tcl.core.nature", (IModelElement)this.module, (String)this.target);
            if (reader != null) {
                return HTMLPrinter.read((Reader)reader);
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    private String computeInformation() {
        String content = this.getInfo();
        if (content == null) {
            return this.proposal.getDisplayString();
        }
        Matcher matcher = HEADER.matcher(content);
        int start = -1;
        while (matcher.find()) {
            if (start < 0) {
                if (matcher.group(1).toUpperCase().indexOf(SYNOPSIS) < 0) continue;
                start = matcher.end();
                continue;
            }
            return this.formatSynopsis(content.substring(start, matcher.start()));
        }
        return this.proposal.getDisplayString();
    }

    private String formatSynopsis(String synopsis) {
        String part;
        synopsis = CUT_HTML_TAGS.matcher(synopsis).replaceAll(EMPTY);
        String[] parts = EOL.split(synopsis);
        String keyword = this.target;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < parts.length) {
            part = parts[i].trim();
            if (part.length() != 0 && part.startsWith(keyword)) {
                if (sb.length() != 0) {
                    sb.append('\n');
                }
                sb.append(part);
            }
            ++i;
        }
        if (sb.length() == 0) {
            i = 0;
            while (i < parts.length) {
                part = parts[i].trim();
                if (part.length() != 0) {
                    if (sb.length() != 0) {
                        sb.append('\n');
                    }
                    sb.append(part);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TclKeywordLazyContextInformation) {
            TclKeywordLazyContextInformation other = (TclKeywordLazyContextInformation)obj;
            String displayString = this.proposal.getDisplayString();
            if (displayString != null ? !displayString.equals(other.proposal.getDisplayString()) : other.proposal.getDisplayString() != null) {
                return false;
            }
            return this.getContextInformationPosition() == other.getContextInformationPosition();
        }
        return false;
    }

    public int getContextInformationPosition() {
        if (this.proposal instanceof ICompletionProposalExtension) {
            return ((ICompletionProposalExtension)this.proposal).getContextInformationPosition();
        }
        return -1;
    }
}

