/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.EclipsePreferencesAdapter;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractDLTKUILanguageToolkit
implements IDLTKUILanguageToolkit {
    private IPreferenceStore fCombinedPreferenceStore;

    public ScriptUILabelProvider createScriptUILabelProvider() {
        return null;
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguration() {
        return null;
    }

    public String getDebugPreferencePage() {
        return null;
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            ArrayList<IPreferenceStore> scopes = new ArrayList<IPreferenceStore>();
            scopes.add(this.getPreferenceStore());
            String qualifier = this.getCoreToolkit().getPreferenceQualifier();
            if (qualifier != null) {
                scopes.add(new EclipsePreferencesAdapter(InstanceScope.INSTANCE, qualifier));
            }
            scopes.add(DLTKUIPlugin.getDefault().getPreferenceStore());
            scopes.add(new EclipsePreferencesAdapter(InstanceScope.INSTANCE, "org.eclipse.dltk.core"));
            scopes.add(EditorsUI.getPreferenceStore());
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(scopes.toArray(new IPreferenceStore[scopes.size()]));
        }
        return this.fCombinedPreferenceStore;
    }

    public boolean getProvideMembers(ISourceModule element) {
        return true;
    }

    public ScriptElementLabels getScriptElementLabels() {
        return new ScriptElementLabels();
    }

    protected final Object getUIPLugin() {
        return null;
    }

    public String getEditorId(Object inputElement) {
        IDLTKLanguageToolkit toolkit = this.getCoreToolkit();
        String contentTypeID = toolkit.getLanguageContentType();
        if (contentTypeID == null) {
            return null;
        }
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType contentType = contentTypeManager.getContentType(contentTypeID);
        if (contentType == null) {
            return null;
        }
        String fileName = null;
        if (inputElement instanceof ISourceModule) {
            fileName = ((ISourceModule)inputElement).getPath().toString();
        } else if (inputElement instanceof IResource) {
            fileName = ((IResource)inputElement).getFullPath().toString();
        }
        IEditorDescriptor editor = editorRegistry.getDefaultEditor(fileName, contentType);
        if (editor != null) {
            return editor.getId();
        }
        return null;
    }

    public String getInterpreterContainerId() {
        return null;
    }

    public String getInterpreterPreferencePage() {
        return null;
    }

    public String getPartitioningId() {
        return "__default_dltk_partitioning";
    }

    public ScriptTextTools getTextTools() {
        return new ScriptTextTools(this.getPartitioningId(), CharOperation.NO_STRINGS, true){

            public ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
                return null;
            }
        };
    }

    public String[] getEditorPreferencePages() {
        return null;
    }

    public String getEditorTemplatesPreferencePageId() {
        String[] pages = this.getEditorPreferencePages();
        if (pages != null && pages.length != 0) {
            String selected = null;
            String[] stringArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                String page = stringArray[n2];
                if (page.toLowerCase().contains("templates")) {
                    if (selected != null) {
                        return null;
                    }
                    selected = page;
                }
                ++n2;
            }
            return selected;
        }
        return null;
    }

    public ITemplateAccess getEditorTemplates() {
        return null;
    }

    public boolean getBoolean(String name) {
        return this.getPreferenceStore().getBoolean(name);
    }

    public int getInt(String name) {
        return this.getPreferenceStore().getInt(name);
    }

    public String getString(String name) {
        return this.getPreferenceStore().getString(name);
    }
}

