/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.ArrayList;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingPart;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;

public class MembersView
extends ScriptBrowsingPart
implements IPropertyChangeListener {
    public MembersView() {
        this.setHasWorkingSetFilter(false);
        this.setHasCustomSetFilter(true);
        DLTKUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.dltk.ui.ScriptExplorer"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected ScriptUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x201000000402BL | ScriptElementLabels.ALL_CATEGORY, 1, DLTKUIPlugin.getDefault().getPreferenceStore());
    }

    protected String getHelpContextId() {
        return "";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.dltk.ui.browsing.member.to.editor";
    }

    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer viewer = new ProblemTreeViewer(parent, 2);
        return viewer;
    }

    protected void fillToolBar(IToolBarManager tbm) {
        super.fillToolBar(tbm);
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }

    protected void setInput(Object input) {
        super.setInput(input);
    }

    private IModelElement[] getCategoryFilterActionGroupInput() {
        Object input = this.getInput();
        if (input instanceof IModelElement) {
            return new IModelElement[]{(IModelElement)input};
        }
        return new IModelElement[0];
    }

    protected boolean isValidInput(Object element) {
        return element instanceof ISourceModule || element instanceof IType;
    }

    protected IContentProvider createContentProvider() {
        final ITreeContentProvider original = (ITreeContentProvider)super.createContentProvider();
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                Object[] children = original.getChildren(parentElement);
                ArrayList<Object> newChildren = new ArrayList<Object>();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IField || children[i] instanceof IMethod || children[i] instanceof IPackageDeclaration) {
                        newChildren.add(children[i]);
                    }
                    ++i;
                }
                return newChildren.toArray();
            }

            public Object getParent(Object element) {
                return original.getParent(element);
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                Object[] children = original.getElements(inputElement);
                ArrayList<Object> newChildren = new ArrayList<Object>();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IField || children[i] instanceof IMethod || children[i] instanceof IPackageDeclaration) {
                        newChildren.add(children[i]);
                    }
                    ++i;
                }
                return newChildren.toArray();
            }

            public void dispose() {
                original.dispose();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                original.inputChanged(viewer, oldInput, newInput);
            }
        };
    }

    protected boolean isValidElement(Object element) {
        return element instanceof IField || element instanceof IMethod || element instanceof IPackageDeclaration;
    }

    protected IModelElement findElementToSelect(IModelElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                return je;
            }
            case 8: 
            case 9: 
            case 10: {
                return je;
            }
            case 5: {
                return je;
            }
        }
        return je;
    }

    protected IModelElement findInputForJavaElement(IModelElement je) {
        if (je == null || !je.exists() || je.getScriptProject() != null && !je.getScriptProject().isOnBuildpath(je)) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                return je;
            }
            case 5: {
                return je;
            }
        }
        return je;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    protected void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().refresh();
        this.getViewer().getControl().setRedraw(true);
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)MembersView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    boolean isInputAWorkingCopy() {
        ISourceModule cu;
        Object input = this.getViewer().getInput();
        if (input instanceof IModelElement && (cu = (ISourceModule)((IModelElement)input).getAncestor(5)) != null) {
            return cu.isWorkingCopy();
        }
        return false;
    }

    protected void restoreSelection() {
        IEditorPart editor = this.getViewSite().getPage().getActiveEditor();
        if (editor != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.getViewer().refresh();
        }
    }

    public void dispose() {
        super.dispose();
        DLTKUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

