/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.client;

import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.util.UrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedRequest<V>
extends GitHubRequest {
    public static final int PAGE_FIRST = 1;
    public static final int PAGE_SIZE = 100;
    private final int pageSize;
    private final int page;

    public PagedRequest() {
        this(1, 100);
    }

    public PagedRequest(int start, int size) {
        this.page = start;
        this.pageSize = size;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    protected void addParams(StringBuilder uri) {
        int number;
        super.addParams(uri);
        int size = this.getPageSize();
        if (size > 0) {
            UrlUtils.addParam("per_page", Integer.toString(size), uri);
        }
        if ((number = this.getPage()) > 0) {
            UrlUtils.addParam("page", Integer.toString(number), uri);
        }
    }

    public int getPage() {
        return this.page;
    }
}

