/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.revision;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.id.CDOWithID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.CDOFeatureMapEntryImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisableImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionCacheAuditing;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionCacheBranching;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionCacheNonAuditing;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionKeyImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionManagerImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureMapEntry;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDORevisionUtil {
    public static final Object UNINITIALIZED = new Uninitialized();
    private static EAttribute resourceNodeNameAttribute;

    private CDORevisionUtil() {
    }

    public static CDORevisionCache createRevisionCache(boolean supportingAudits, boolean supportingBranches) {
        if (supportingBranches) {
            return new CDORevisionCacheBranching();
        }
        if (supportingAudits) {
            return new CDORevisionCacheAuditing();
        }
        return new CDORevisionCacheNonAuditing();
    }

    public static CDORevisionManager createRevisionManager() {
        return new CDORevisionManagerImpl();
    }

    public static CDORevisionManager createRevisionManager(CDORevisionCache cache) {
        InternalCDORevisionManager revisionManager = (InternalCDORevisionManager)CDORevisionUtil.createRevisionManager();
        revisionManager.setCache(cache);
        return revisionManager;
    }

    public static CDORevisable copyRevisable(CDORevisable source) {
        return new CDORevisableImpl(source);
    }

    public static CDORevisable createRevisable(CDOBranch branch, int version, long timeStamp, long revised) {
        return new CDORevisableImpl(branch, version, timeStamp, revised);
    }

    public static CDORevisionKey copyRevisionKey(CDORevisionKey source) {
        return new CDORevisionKeyImpl(source.getID(), source.getBranch(), source.getVersion());
    }

    public static CDORevisionKey createRevisionKey(CDOID id, CDOBranch branch, int version) {
        return new CDORevisionKeyImpl(id, branch, version);
    }

    public static String formatRevisionKey(CDORevisionKey key) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write(builder, key.getID());
        builder.append(":");
        builder.append(key.getBranch().getID());
        builder.append(":");
        builder.append(key.getVersion());
        return builder.toString();
    }

    public static CDORevisionKey parseRevisionKey(String source, CDOBranchManager branchManager) {
        StringTokenizer tokenizer = new StringTokenizer(source, ":");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("No ID segment");
        }
        String idSegment = tokenizer.nextToken();
        CDOID id = CDOIDUtil.read(idSegment);
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("No branch segment");
        }
        String branchSegment = tokenizer.nextToken();
        CDOBranch branch = branchManager.getBranch(Integer.parseInt(branchSegment));
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("No version segment");
        }
        String versionSegment = tokenizer.nextToken();
        int version = Integer.parseInt(versionSegment);
        return new CDORevisionKeyImpl(id, branch, version);
    }

    public static FeatureMap.Entry createFeatureMapEntry(EStructuralFeature feature, Object value) {
        return new CDOFeatureMapEntryImpl(feature, value);
    }

    public static CDOFeatureMapEntry createCDOFeatureMapEntry() {
        return new CDOFeatureMapEntryImpl();
    }

    public static CDORevisionDelta createDelta(CDORevision revision) {
        return new CDORevisionDeltaImpl(revision);
    }

    public static CDOChangeSetData createChangeSetData(Set<CDOID> ids, CDOBranchPoint startPoint, CDOBranchPoint endPoint, CDORevisionManager revisionManager) {
        ManagedRevisionProvider startProvider = new ManagedRevisionProvider(revisionManager, startPoint);
        ManagedRevisionProvider endProvider = new ManagedRevisionProvider(revisionManager, endPoint);
        return CDORevisionUtil.createChangeSetData(ids, startProvider, endProvider);
    }

    public static CDOChangeSetData createChangeSetData(Set<CDOID> ids, CDORevisionProvider startProvider, CDORevisionProvider endProvider) {
        return CDORevisionUtil.createChangeSetData(ids, startProvider, endProvider, false);
    }

    public static CDOChangeSetData createChangeSetData(Set<CDOID> ids, CDORevisionProvider startProvider, CDORevisionProvider endProvider, boolean useStartVersions) {
        ArrayList<CDOIDAndVersion> newObjects = new ArrayList<CDOIDAndVersion>();
        ArrayList<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>();
        ArrayList<CDOIDAndVersion> detachedObjects = new ArrayList<CDOIDAndVersion>();
        for (CDOID id : ids) {
            CDORevisionDelta delta;
            CDORevision startRevision = startProvider.getRevision(id);
            CDORevision endRevision = endProvider.getRevision(id);
            if (startRevision == null && endRevision != null) {
                if (useStartVersions) {
                    ((InternalCDORevision)endRevision).setVersion(0);
                }
                newObjects.add(endRevision);
                continue;
            }
            if (startRevision != null && endRevision == null) {
                detachedObjects.add(CDOIDUtil.createIDAndVersion(id, 0));
                continue;
            }
            if (startRevision == null || endRevision == null || startRevision.equals(endRevision)) continue;
            if (useStartVersions) {
                ((InternalCDORevision)endRevision).setVersion(startRevision.getVersion());
            }
            if ((delta = endRevision.compare(startRevision)).isEmpty()) continue;
            changedObjects.add(delta);
        }
        return CDORevisionUtil.createChangeSetData(newObjects, changedObjects, detachedObjects);
    }

    public static CDOChangeSetData createChangeSetData(List<CDOIDAndVersion> newObjects, List<CDORevisionKey> changedObjects, List<CDOIDAndVersion> detachedObjects) {
        return new CDOChangeSetDataImpl(newObjects, changedObjects, detachedObjects);
    }

    public static CDOChangeSet createChangeSet(CDOBranchPoint startPoint, CDOBranchPoint endPoint, CDOChangeSetData data) {
        return new CDOChangeSetImpl(startPoint, endPoint, data);
    }

    public static Object remapID(Object value, Map<CDOID, CDOID> idMappings, boolean allowUnmappedTempIDs) {
        return CDORevisionImpl.remapID(value, idMappings, allowUnmappedTempIDs);
    }

    public static String getResourceNodePath(CDORevision revision, CDORevisionProvider provider) {
        StringBuilder builder = new StringBuilder();
        CDORevisionUtil.getResourceNodePath((InternalCDORevision)revision, provider, builder);
        return builder.toString();
    }

    private static void getResourceNodePath(InternalCDORevision revision, CDORevisionProvider provider, StringBuilder result) {
        EAttribute attribute;
        InternalCDORevision container = CDORevisionUtil.getParentRevision(revision, provider);
        if (container != null) {
            CDORevisionUtil.getResourceNodePath(container, provider, result);
        }
        if ((attribute = CDORevisionUtil.getResourceNodeNameAttribute(revision)) != null) {
            String name;
            int length = result.length();
            if (length == 0 || result.charAt(length - 1) != '/') {
                result.append("/");
            }
            if ((name = (String)revision.get((EStructuralFeature)attribute, 0)) != null) {
                result.append(name);
            }
        }
    }

    private static InternalCDORevision getParentRevision(InternalCDORevision revision, CDORevisionProvider provider) {
        Object containerID = revision.getContainerID();
        CDOID parentID = containerID instanceof CDOWithID ? ((CDOWithID)containerID).cdoID() : (CDOID)containerID;
        if (CDOIDUtil.isNull(parentID)) {
            parentID = revision.getResourceID();
            if (CDOIDUtil.isNull(parentID)) {
                return null;
            }
            if (parentID == revision.getID()) {
                return null;
            }
        }
        return (InternalCDORevision)provider.getRevision(parentID);
    }

    private static EAttribute getResourceNodeNameAttribute(CDORevision revision) {
        if (revision.isResourceNode()) {
            if (resourceNodeNameAttribute == null) {
                resourceNodeNameAttribute = (EAttribute)revision.getEClass().getEStructuralFeature("name");
            }
            return resourceNodeNameAttribute;
        }
        return null;
    }

    public static String dumpAllRevisions(Map<CDOBranch, List<CDORevision>> map) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        CDORevisionUtil.dumpAllRevisions(map, out);
        return baos.toString();
    }

    public static void dumpAllRevisions(Map<CDOBranch, List<CDORevision>> map, PrintStream out) {
        new AllRevisionsDumper.Stream.Plain(map, out).dump();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AllRevisionsDumper {
        private Map<CDOBranch, List<CDORevision>> map;

        public AllRevisionsDumper(Map<CDOBranch, List<CDORevision>> map) {
            this.map = map;
        }

        public Map<CDOBranch, List<CDORevision>> getMap() {
            return this.map;
        }

        public void dump() {
            ArrayList<CDOBranch> branches = new ArrayList<CDOBranch>(this.map.keySet());
            Collections.sort(branches);
            this.dumpStart(branches);
            for (CDOBranch branch : branches) {
                this.dumpBranch(branch);
                List<CDORevision> revisions = this.map.get(branch);
                Collections.sort(revisions, new CDORevisionComparator());
                for (CDORevision revision : revisions) {
                    this.dumpRevision(revision);
                }
            }
            this.dumpEnd(branches);
        }

        protected void dumpStart(List<CDOBranch> branches) {
        }

        protected void dumpEnd(List<CDOBranch> branches) {
        }

        protected abstract void dumpBranch(CDOBranch var1);

        protected abstract void dumpRevision(CDORevision var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Stream
        extends AllRevisionsDumper {
            private PrintStream out;

            public Stream(Map<CDOBranch, List<CDORevision>> map, PrintStream out) {
                super(map);
                this.out = out;
            }

            public PrintStream out() {
                return this.out;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Html
            extends Stream {
                public Html(Map<CDOBranch, List<CDORevision>> map, PrintStream out) {
                    super(map, out);
                }

                @Override
                protected void dumpStart(List<CDOBranch> branches) {
                    this.out().println("<table border=\"0\">");
                }

                @Override
                protected void dumpEnd(List<CDOBranch> branches) {
                    this.out().println("</table>");
                }

                @Override
                protected void dumpBranch(CDOBranch branch) {
                    PrintStream out = this.out();
                    if (!branch.isMainBranch()) {
                        out.println("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
                    }
                    out.println("<tr>");
                    out.println("<td>");
                    out.println("<h4>" + branch.getName() + "[" + branch.getID() + "]</h4>");
                    out.println("</td>");
                    out.println("<td>");
                    out.println("<h4>" + CDOCommonUtil.formatTimeStamp(branch.getBase().getTimeStamp()) + " / " + CDOCommonUtil.formatTimeStamp(0L) + "</h4>");
                    out.println("</td>");
                    out.println("</tr>");
                }

                @Override
                protected void dumpRevision(CDORevision revision) {
                    PrintStream out = this.out();
                    out.println("<tr>");
                    out.println("<td>&nbsp;&nbsp;&nbsp;&nbsp;");
                    this.dumpRevision(revision, out);
                    out.println("&nbsp;&nbsp;&nbsp;&nbsp;</td>");
                    out.println("<td>");
                    out.println(String.valueOf(CDOCommonUtil.formatTimeStamp(revision.getTimeStamp())) + " / " + CDOCommonUtil.formatTimeStamp(revision.getRevised()));
                    out.println("</td>");
                    out.println("</tr>");
                }

                protected void dumpRevision(CDORevision revision, PrintStream out) {
                    out.println(revision);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Plain
            extends Stream {
                public static final int pad = 48;

                public Plain(Map<CDOBranch, List<CDORevision>> map, PrintStream out) {
                    super(map, out);
                }

                @Override
                protected void dumpEnd(List<CDOBranch> branches) {
                    this.out().println();
                }

                @Override
                protected void dumpBranch(CDOBranch branch) {
                    this.out().println(Plain.padTimeRange(String.valueOf(branch.getName()) + "[" + branch.getID() + "]", 48, branch.getBase().getTimeStamp(), 0L));
                }

                @Override
                protected void dumpRevision(CDORevision revision) {
                    this.out().println(Plain.padTimeRange("  " + revision, 48, revision.getTimeStamp(), revision.getRevised()));
                }

                private static String padTimeRange(String s, int pos, long t1, long t2) {
                    StringBuffer buffer = new StringBuffer(s);
                    while (buffer.length() < pos) {
                        buffer.append(' ');
                    }
                    buffer.append(CDOCommonUtil.formatTimeStamp(t1));
                    buffer.append("/");
                    buffer.append(CDOCommonUtil.formatTimeStamp(t2));
                    return buffer.toString();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CDORevisionComparator
    implements Comparator<CDORevisionKey> {
        @Override
        public int compare(CDORevisionKey rev1, CDORevisionKey rev2) {
            int result = rev1.getID().compareTo(rev2.getID());
            if (result == 0) {
                int version2;
                int version1 = rev1.getVersion();
                result = version1 < (version2 = rev2.getVersion()) ? -1 : (version1 == version2 ? 0 : 1);
            }
            return result;
        }
    }

    private static final class Uninitialized {
        public String toString() {
            return Messages.getString("CDORevisionUtil.0");
        }
    }
}

