/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassInfo;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.model.CDOPersistenceFilterImpl;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.StubCDORevision;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.ImplementationError;

public final class CDOClassInfoImpl
implements InternalCDOClassInfo,
Adapter.Internal {
    private static final InternalCDOClassInfo.PersistenceFilter[] NO_FILTERS = new InternalCDOClassInfo.PersistenceFilter[0];
    private final InternalCDORevision revisionWithoutID = new RevisionWithoutID(this);
    private EClass eClass;
    private final BitSet persistentBits = new BitSet();
    private final BitSet persistentOppositeBits = new BitSet();
    private InternalCDOClassInfo.PersistenceFilter[] persistenceFilters = NO_FILTERS;
    private EStructuralFeature[] allPersistentFeatures;
    private EReference[] allPersistentReferences;
    private EStructuralFeature[] allPersistentContainments;
    private int[] persistentFeatureIndices;
    private int settingsFeatureCount;
    private int[] settingsFeatureIndices;
    private int transientFeatureCount;
    private int[] transientFeatureIndices;

    public InternalCDORevision getRevisionForID(CDOID id) {
        if (id == null) {
            return this.revisionWithoutID;
        }
        return new RevisionWithID(this, id);
    }

    public boolean isAdapterForType(Object type) {
        return type == CDOClassInfo.class;
    }

    public void notifyChanged(Notification notification) {
    }

    public EClass getTarget() {
        return this.eClass;
    }

    public void setTarget(Notifier newTarget) {
        this.init((EClass)newTarget);
    }

    public void unsetTarget(Notifier oldTarget) {
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public boolean isResource() {
        return CDOModelUtil.isResource(this.eClass);
    }

    public boolean isResourceFolder() {
        return CDOModelUtil.isResourceFolder(this.eClass);
    }

    public boolean isResourceNode() {
        return CDOModelUtil.isResourceNode(this.eClass);
    }

    public boolean isPersistent(int featureID) {
        return this.persistentBits.get(featureID);
    }

    public boolean isPersistent(EStructuralFeature feature) {
        int featureID = this.eClass.getFeatureID(feature);
        return this.isPersistent(featureID);
    }

    public boolean hasPersistentOpposite(EStructuralFeature feature) {
        int featureID = this.eClass.getFeatureID(feature);
        return this.persistentOppositeBits.get(featureID);
    }

    public EStructuralFeature[] getAllPersistentFeatures() {
        return this.allPersistentFeatures;
    }

    public EReference[] getAllPersistentReferences() {
        return this.allPersistentReferences;
    }

    public EStructuralFeature[] getAllPersistentContainments() {
        return this.allPersistentContainments;
    }

    public int getPersistentFeatureIndex(EStructuralFeature feature) throws IllegalArgumentException {
        int featureID = this.eClass.getFeatureID(feature);
        return this.getPersistentFeatureIndex(featureID);
    }

    public int getPersistentFeatureIndex(int featureID) throws IllegalArgumentException {
        int index = this.persistentFeatureIndices[featureID];
        if (index == -1) {
            throw new IllegalArgumentException("Feature not mapped: " + this.eClass.getEStructuralFeature(featureID));
        }
        return index;
    }

    public int getSettingsFeatureCount() {
        return this.settingsFeatureCount;
    }

    public int getSettingsFeatureIndex(int featureID) {
        return this.settingsFeatureIndices[featureID];
    }

    public int getTransientFeatureCount() {
        return this.transientFeatureCount;
    }

    public int getTransientFeatureIndex(int featureID) {
        return this.transientFeatureIndices[featureID];
    }

    public int getTransientFeatureIndex(EStructuralFeature feature) {
        int featureID = this.eClass.getFeatureID(feature);
        return this.getTransientFeatureIndex(featureID);
    }

    public InternalCDOClassInfo.PersistenceFilter getPersistenceFilter(EStructuralFeature feature) {
        if (this.persistenceFilters == NO_FILTERS) {
            return null;
        }
        int featureID = this.eClass.getFeatureID(feature);
        return this.persistenceFilters[featureID];
    }

    private InternalCDOClassInfo.PersistenceFilter initPersistenceFilter(EStructuralFeature feature) {
        CDOPersistenceFilterImpl result = null;
        String filter = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http://www.eclipse.org/emf/CDO", (String)"filter");
        if (filter != null) {
            EStructuralFeature dependency = feature.getEContainingClass().getEStructuralFeature(filter);
            if (dependency != null) {
                result = new CDOPersistenceFilterImpl(dependency);
            } else {
                OM.LOG.warn("Persistence filter '" + filter + "' not found for " + feature);
            }
        }
        return result;
    }

    private void init(EClass eClass) {
        int featureID;
        EStructuralFeature feature;
        this.eClass = eClass;
        EList allFeatures = eClass.getEAllStructuralFeatures();
        int featureCount = eClass.getFeatureCount();
        ArrayList<EStructuralFeature> persistentFeatures = new ArrayList<EStructuralFeature>();
        ArrayList<EReference> persistentReferences = new ArrayList<EReference>();
        ArrayList<EStructuralFeature> persistentContainments = new ArrayList<EStructuralFeature>();
        EStructuralFeature[] containments = ((EClassImpl.FeatureSubsetSupplier)eClass.getEAllStructuralFeatures()).containments();
        this.persistentBits.clear();
        this.persistentOppositeBits.clear();
        this.settingsFeatureIndices = new int[featureCount];
        int i = 0;
        while (i < featureCount) {
            feature = eClass.getEStructuralFeature(i);
            if (EMFUtil.isPersistent(feature)) {
                featureID = eClass.getFeatureID(feature);
                this.persistentBits.set(featureID);
                persistentFeatures.add(feature);
                if (this.isContainment(containments, feature)) {
                    persistentContainments.add(feature);
                }
                if (feature instanceof EReference) {
                    EReference reference = (EReference)feature;
                    persistentReferences.add(reference);
                    EReference opposite = reference.getEOpposite();
                    if (opposite != null && EMFUtil.isPersistent((EStructuralFeature)opposite)) {
                        this.persistentOppositeBits.set(featureID);
                    }
                }
                if (feature.isMany() || FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                    ++this.settingsFeatureCount;
                } else {
                    this.settingsFeatureIndices[i] = -1;
                }
            } else {
                ++this.settingsFeatureCount;
            }
            ++i;
        }
        this.transientFeatureIndices = new int[featureCount];
        int featureID2 = 0;
        while (featureID2 < featureCount) {
            this.transientFeatureIndices[featureID2] = this.isPersistent(featureID2) ? this.settingsFeatureCount + this.transientFeatureCount++ : this.settingsFeatureIndices[featureID2];
            ++featureID2;
        }
        this.allPersistentFeatures = persistentFeatures.toArray(new EStructuralFeature[persistentFeatures.size()]);
        this.allPersistentReferences = persistentReferences.toArray(new EReference[persistentReferences.size()]);
        this.allPersistentContainments = persistentContainments.toArray(new EStructuralFeature[persistentContainments.size()]);
        this.persistentFeatureIndices = new int[allFeatures.size()];
        Arrays.fill(this.persistentFeatureIndices, -1);
        i = 0;
        while (i < this.allPersistentFeatures.length) {
            feature = this.allPersistentFeatures[i];
            featureID = eClass.getFeatureID(feature);
            this.persistentFeatureIndices[featureID] = i;
            InternalCDOClassInfo.PersistenceFilter persistenceFilter = this.initPersistenceFilter(feature);
            if (persistenceFilter != null) {
                if (this.persistenceFilters == NO_FILTERS) {
                    this.persistenceFilters = new InternalCDOClassInfo.PersistenceFilter[allFeatures.size()];
                }
                this.persistenceFilters[featureID] = persistenceFilter;
            }
            ++i;
        }
    }

    private boolean isContainment(EStructuralFeature[] containments, EStructuralFeature feature) {
        if (containments != null) {
            EStructuralFeature[] eStructuralFeatureArray = containments;
            int n = containments.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature containment = eStructuralFeatureArray[n2];
                if (containment == feature) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Deprecated
    public int getFeatureIndex(EStructuralFeature feature) {
        return this.getPersistentFeatureIndex(feature);
    }

    @Deprecated
    public int getFeatureIndex(int featureID) {
        return this.getPersistentFeatureIndex(featureID);
    }

    public String toString() {
        return this.eClass.toString();
    }

    private static final class RevisionWithID
    extends StubCDORevision {
        private final CDOID id;

        public RevisionWithID(InternalCDOClassInfo classInfo, CDOID id) {
            super(classInfo);
            this.id = id;
        }

        public CDOID getID() {
            return this.id;
        }

        public InternalCDORevision getRevisionForID(CDOID id) {
            if (id == null) {
                return this.getClassInfo().getRevisionForID(null);
            }
            if (id.equals(this.id)) {
                throw new ImplementationError();
            }
            return new RevisionWithID(this.getClassInfo(), id);
        }

        public InternalCDORevision getProperRevision() {
            return null;
        }
    }

    private static final class RevisionWithoutID
    extends StubCDORevision {
        public RevisionWithoutID(InternalCDOClassInfo classInfo) {
            super(classInfo);
        }

        public CDOID getID() {
            return null;
        }

        public InternalCDORevision getRevisionForID(CDOID id) {
            if (id == null) {
                return this;
            }
            return new RevisionWithID(this.getClassInfo(), id);
        }

        public InternalCDORevision getProperRevision() {
            return null;
        }
    }
}

