/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.ClassPermission;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.PackagePermission;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.ResourcePermission;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.security.impl.ClassPermissionImpl;
import org.eclipse.emf.cdo.security.impl.DirectoryImpl;
import org.eclipse.emf.cdo.security.impl.GroupImpl;
import org.eclipse.emf.cdo.security.impl.PackagePermissionImpl;
import org.eclipse.emf.cdo.security.impl.RealmImpl;
import org.eclipse.emf.cdo.security.impl.ResourcePermissionImpl;
import org.eclipse.emf.cdo.security.impl.RoleImpl;
import org.eclipse.emf.cdo.security.impl.UserImpl;
import org.eclipse.emf.cdo.security.impl.UserPasswordImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class SecurityFactoryImpl
extends EFactoryImpl
implements SecurityFactory {
    public static SecurityFactory init() {
        try {
            SecurityFactory theSecurityFactory = (SecurityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/CDO/security/4.1.0");
            if (theSecurityFactory != null) {
                return theSecurityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SecurityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createRealm();
            }
            case 3: {
                return this.createDirectory();
            }
            case 4: {
                return this.createRole();
            }
            case 6: {
                return this.createGroup();
            }
            case 7: {
                return this.createUser();
            }
            case 8: {
                return this.createUserPassword();
            }
            case 10: {
                return this.createClassPermission();
            }
            case 11: {
                return this.createPackagePermission();
            }
            case 12: {
                return this.createResourcePermission();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.createAccessFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createAccessObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.convertAccessToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertAccessObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Realm createRealm() {
        RealmImpl realm = new RealmImpl();
        return realm;
    }

    public Realm createRealm(String name) {
        Realm realm = this.createRealm();
        realm.setName(name);
        return realm;
    }

    public Realm createRealm(String name, Access defaultAccess) {
        Realm realm = this.createRealm(name);
        realm.setDefaultAccess(defaultAccess);
        return realm;
    }

    public Directory createDirectory(String name) {
        Directory directory = this.createDirectory();
        directory.setName(name);
        return directory;
    }

    public Role createRole(String id) {
        Role role = this.createRole();
        role.setId(id);
        return role;
    }

    public Group createGroup(String id) {
        Group group = this.createGroup();
        group.setId(id);
        return group;
    }

    public User createUser(String id) {
        User user = this.createUser();
        user.setId(id);
        return user;
    }

    public User createUser(String id, String password) {
        UserPassword userPassword = this.createUserPassword();
        userPassword.setEncrypted(password);
        User user = this.createUser(id);
        user.setPassword(userPassword);
        return user;
    }

    public ClassPermission createClassPermission(EClass eClass, Access access) {
        ClassPermission permission = this.createClassPermission();
        permission.setApplicableClass(eClass);
        permission.setAccess(access);
        return permission;
    }

    public PackagePermission createPackagePermission(EPackage ePackage, Access access) {
        PackagePermission permission = this.createPackagePermission();
        permission.setApplicablePackage(ePackage);
        permission.setAccess(access);
        return permission;
    }

    public ResourcePermission createResourcePermission(String pattern, Access access) {
        ResourcePermission permission = this.createResourcePermission();
        permission.setPattern(pattern);
        permission.setAccess(access);
        return permission;
    }

    public Directory createDirectory() {
        DirectoryImpl directory = new DirectoryImpl();
        return directory;
    }

    public Role createRole() {
        RoleImpl role = new RoleImpl();
        return role;
    }

    public Group createGroup() {
        GroupImpl group = new GroupImpl();
        return group;
    }

    public User createUser() {
        UserImpl user = new UserImpl();
        return user;
    }

    public UserPassword createUserPassword() {
        UserPasswordImpl userPassword = new UserPasswordImpl();
        return userPassword;
    }

    public ClassPermission createClassPermission() {
        ClassPermissionImpl classPermission = new ClassPermissionImpl();
        return classPermission;
    }

    public PackagePermission createPackagePermission() {
        PackagePermissionImpl packagePermission = new PackagePermissionImpl();
        return packagePermission;
    }

    public ResourcePermission createResourcePermission() {
        ResourcePermissionImpl resourcePermission = new ResourcePermissionImpl();
        return resourcePermission;
    }

    public Access createAccessFromString(EDataType eDataType, String initialValue) {
        Access result = Access.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertAccessToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Access createAccessObjectFromString(EDataType eDataType, String initialValue) {
        return this.createAccessFromString((EDataType)SecurityPackage.Literals.ACCESS, initialValue);
    }

    public String convertAccessObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertAccessToString((EDataType)SecurityPackage.Literals.ACCESS, instanceValue);
    }

    public SecurityPackage getSecurityPackage() {
        return (SecurityPackage)this.getEPackage();
    }

    @Deprecated
    public static SecurityPackage getPackage() {
        return SecurityPackage.eINSTANCE;
    }
}

