/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.security.ViewCreator;
import org.eclipse.emf.cdo.internal.security.ViewUtil;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.ClassPermission;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.IAuthenticator;

public class SecurityManager
extends Lifecycle
implements InternalSecurityManager {
    private IListener repositoryListener = new LifecycleEventAdapter(){

        protected void onActivated(ILifecycle lifecycle) {
            SecurityManager.this.init();
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            SecurityManager.this.deactivate();
        }
    };
    private final IAuthenticator authenticator = new Authenticator();
    private final IPermissionManager permissionManager = new PermissionManager();
    private final IRepository.WriteAccessHandler writeAccessHandler = new WriteAccessHandler();
    private final List<InternalSecurityManager.CommitHandler> commitHandlers = new ArrayList<InternalSecurityManager.CommitHandler>();
    private final String realmPath;
    private final IManagedContainer container;
    private final Map<String, User> users = Collections.synchronizedMap(new HashMap());
    private InternalRepository repository;
    private IAcceptor acceptor;
    private IConnector connector;
    private CDONet4jSession session;
    private CDOView view;
    private Realm realm;

    public SecurityManager(String realmPath, IManagedContainer container) {
        this.realmPath = realmPath;
        this.container = container;
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    public final String getRealmPath() {
        return this.realmPath;
    }

    public final IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(InternalRepository repository) {
        this.repository = repository;
        if (this.isActive()) {
            this.init();
        }
    }

    public Realm getRealm() {
        return this.realm;
    }

    public Role getRole(String id) {
        Role item = this.realm.getRole(id);
        if (item == null) {
            throw new SecurityException("Role " + id + " not found");
        }
        return item;
    }

    public Group getGroup(String id) {
        Group item = this.realm.getGroup(id);
        if (item == null) {
            throw new SecurityException("Group " + id + " not found");
        }
        return item;
    }

    public User getUser(String id) {
        User item = this.users.get(id);
        if (item == null) {
            item = this.realm.getUser(id);
            if (item == null) {
                throw new SecurityException("User " + id + " not found");
            }
            this.users.put(id, item);
        }
        return item;
    }

    public Role addRole(final String id) {
        final Role[] result = new Role[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.addRole(id);
            }
        });
        return result[0];
    }

    public Group addGroup(final String id) {
        final Group[] result = new Group[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.addGroup(id);
            }
        });
        return result[0];
    }

    public User addUser(final String id) {
        final User[] result = new User[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.addUser(id);
            }
        });
        return result[0];
    }

    public User addUser(final String id, final String password) {
        final User[] result = new User[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                UserPassword userPassword = SecurityFactory.eINSTANCE.createUserPassword();
                userPassword.setEncrypted(new String(password));
                result[0] = realm.addUser(id);
                result[0].setPassword(userPassword);
            }
        });
        return result[0];
    }

    public Role removeRole(final String id) {
        final Role[] result = new Role[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.removeRole(id);
            }
        });
        return result[0];
    }

    public Group removeGroup(final String id) {
        final Group[] result = new Group[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.removeGroup(id);
            }
        });
        return result[0];
    }

    public User removeUser(final String id) {
        final User[] result = new User[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.removeUser(id);
            }
        });
        return result[0];
    }

    public void read(ISecurityManager.RealmOperation operation) {
        this.checkActive();
        operation.execute(this.realm);
    }

    public void modify(ISecurityManager.RealmOperation operation) {
        this.modify(operation, false);
    }

    public void modify(ISecurityManager.RealmOperation operation, boolean waitUntilReadable) {
        this.checkActive();
        CDOTransaction transaction = this.session.openTransaction();
        try {
            try {
                Realm transactionRealm = (Realm)transaction.getObject((EObject)this.realm);
                operation.execute(transactionRealm);
                CDOCommitInfo commit = transaction.commit();
                if (waitUntilReadable) {
                    this.view.waitForUpdate(commit.getTimeStamp());
                }
            }
            catch (CommitException ex) {
                throw WrappedException.wrap((Exception)((Object)ex));
            }
        }
        finally {
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalSecurityManager.CommitHandler[] getCommitHandlers() {
        List<InternalSecurityManager.CommitHandler> list = this.commitHandlers;
        synchronized (list) {
            return this.commitHandlers.toArray(new InternalSecurityManager.CommitHandler[this.commitHandlers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        List<InternalSecurityManager.CommitHandler> list = this.commitHandlers;
        synchronized (list) {
            if (!this.commitHandlers.contains(handler)) {
                this.commitHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        List<InternalSecurityManager.CommitHandler> list = this.commitHandlers;
        synchronized (list) {
            this.commitHandlers.remove(handler);
        }
    }

    protected void initCommitHandlers(boolean firstTime) {
        InternalSecurityManager.CommitHandler[] commitHandlerArray = this.getCommitHandlers();
        int n = commitHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSecurityManager.CommitHandler handler = commitHandlerArray[n2];
            try {
                handler.init(this, firstTime);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    protected void handleCommit(IStoreAccessor.CommitContext commitContext, User user) {
        InternalSecurityManager.CommitHandler[] commitHandlerArray = this.getCommitHandlers();
        int n = commitHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSecurityManager.CommitHandler handler = commitHandlerArray[n2];
            try {
                handler.handleCommit(this, commitContext, user);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    protected void init() {
        CDOResource resource;
        boolean firstTime;
        if (this.realm != null) {
            return;
        }
        if (this.repository == null) {
            return;
        }
        this.repository.addListener(this.repositoryListener);
        if (!LifecycleUtil.isActive((Object)this.repository)) {
            return;
        }
        String repositoryName = this.repository.getName();
        String acceptorName = String.valueOf(repositoryName) + "_security";
        this.acceptor = Net4jUtil.getAcceptor((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        this.connector = Net4jUtil.getConnector((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(this.connector);
        config.setRepositoryName(repositoryName);
        config.setUserID("CDO_SYSTEM");
        this.session = config.openNet4jSession();
        CDOTransaction transaction = this.session.openTransaction();
        boolean bl = firstTime = !transaction.hasResource(this.realmPath);
        if (firstTime) {
            resource = transaction.createResource(this.realmPath);
            this.realm = this.createRealm();
            resource.getContents().add((Object)this.realm);
        } else {
            resource = transaction.getResource(this.realmPath);
            this.realm = (Realm)resource.getContents().get(0);
        }
        this.initCommitHandlers(firstTime);
        try {
            try {
                transaction.commit();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            transaction.close();
        }
        this.view = this.session.openView();
        this.realm = (Realm)this.view.getObject((EObject)this.realm);
        InternalSessionManager sessionManager = this.repository.getSessionManager();
        sessionManager.setAuthenticator(this.authenticator);
        sessionManager.setPermissionManager(this.permissionManager);
        this.repository.addHandler((IRepository.Handler)this.writeAccessHandler);
    }

    protected Realm createRealm() {
        Realm realm = SecurityFactory.eINSTANCE.createRealm("Security Realm");
        realm.setDefaultRoleDirectory(this.addDirectory(realm, "Roles"));
        realm.setDefaultGroupDirectory(this.addDirectory(realm, "Groups"));
        realm.setDefaultUserDirectory(this.addDirectory(realm, "Users"));
        Role allReaderRole = realm.addRole("All Objects Reader");
        allReaderRole.getPermissions().add((Object)SecurityFactory.eINSTANCE.createResourcePermission(".*", Access.READ));
        Role allWriterRole = realm.addRole("All Objects Writer");
        allWriterRole.getPermissions().add((Object)SecurityFactory.eINSTANCE.createResourcePermission(".*", Access.WRITE));
        Role treeReaderRole = realm.addRole("Resource Tree Reader");
        treeReaderRole.getPermissions().add((Object)SecurityFactory.eINSTANCE.createPackagePermission((EPackage)EresourcePackage.eINSTANCE, Access.READ));
        Role treeWriterRole = realm.addRole("Resource Tree Writer");
        treeWriterRole.getPermissions().add((Object)SecurityFactory.eINSTANCE.createPackagePermission((EPackage)EresourcePackage.eINSTANCE, Access.WRITE));
        Role adminRole = realm.addRole("Administration");
        EClass[] eClassArray = EMFUtil.getConcreteClasses((EPackage)SecurityPackage.eINSTANCE);
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (eClass != SecurityPackage.Literals.USER_PASSWORD) {
                ClassPermission permission = SecurityFactory.eINSTANCE.createClassPermission(eClass, Access.WRITE);
                adminRole.getPermissions().add((Object)permission);
            }
            ++n2;
        }
        Group adminsGroup = realm.addGroup("Administrators");
        adminsGroup.getRoles().add((Object)treeReaderRole);
        adminsGroup.getRoles().add((Object)adminRole);
        Group usersGroup = realm.addGroup("Users");
        usersGroup.getRoles().add((Object)treeReaderRole);
        User adminUser = realm.addUser("Administrator", "0000");
        adminUser.getGroups().add((Object)adminsGroup);
        return realm;
    }

    protected Directory addDirectory(Realm realm, String name) {
        Directory directory = SecurityFactory.eINSTANCE.createDirectory(name);
        realm.getItems().add((Object)directory);
        return directory;
    }

    protected CDOPermission convertPermission(Access permission) {
        if (permission != null) {
            switch (permission) {
                case READ: {
                    return CDOPermission.READ;
                }
                case WRITE: {
                    return CDOPermission.WRITE;
                }
            }
        }
        return CDOPermission.NONE;
    }

    protected CDOPermission getPermission(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, ISession session, User user) {
        CDOPermission result = this.convertPermission(user.getDefaultAccess());
        if (result == CDOPermission.WRITE) {
            return result;
        }
        EList allPermissions = user.getAllPermissions();
        for (Permission permission : allPermissions) {
            CDOPermission p = this.convertPermission(permission.getAccess());
            if (p.ordinal() <= result.ordinal() || !permission.isApplicable(revision, revisionProvider, securityContext) || (result = p) != CDOPermission.WRITE) continue;
            return result;
        }
        return result;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.init();
    }

    protected void doDeactivate() throws Exception {
        this.users.clear();
        this.realm = null;
        this.session.close();
        this.session = null;
        this.view = null;
        this.connector.close();
        this.connector = null;
        this.acceptor.close();
        this.acceptor = null;
        super.doDeactivate();
    }

    private final class Authenticator
    implements IAuthenticator {
        private Authenticator() {
        }

        public void authenticate(String userID, char[] password) throws SecurityException {
            User user = SecurityManager.this.getUser(userID);
            UserPassword userPassword = user.getPassword();
            String encrypted = userPassword.getEncrypted();
            if (!Arrays.equals(password, encrypted == null ? null : encrypted.toCharArray())) {
                throw new SecurityException("Access denied");
            }
        }
    }

    private final class PermissionManager
    implements IPermissionManager {
        private PermissionManager() {
        }

        public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, ISession session) {
            String userID = session.getUserID();
            if ("CDO_SYSTEM".equals(userID)) {
                return CDOPermission.WRITE;
            }
            return this.doGetPermission(revision, securityContext, session, userID);
        }

        @Deprecated
        public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, String userID) {
            if ("CDO_SYSTEM".equals(userID)) {
                return CDOPermission.WRITE;
            }
            return this.doGetPermission(revision, securityContext, null, userID);
        }

        private CDOPermission doGetPermission(CDORevision revision, final CDOBranchPoint securityContext, final ISession session, String userID) {
            User user = SecurityManager.this.getUser(userID);
            InternalCDORevisionManager revisionManager = SecurityManager.this.repository.getRevisionManager();
            ManagedRevisionProvider revisionProvider = new ManagedRevisionProvider((CDORevisionManager)revisionManager, securityContext);
            ViewUtil.initViewCreation((ViewCreator)new ViewCreator(){

                public CDOView createView(CDORevisionProvider revisionProvider) {
                    return CDOServerUtil.openView((ISession)session, (CDOBranchPoint)securityContext, (CDORevisionProvider)revisionProvider);
                }
            });
            try {
                CDOPermission cDOPermission = SecurityManager.this.getPermission(revision, (CDORevisionProvider)revisionProvider, securityContext, session, user);
                return cDOPermission;
            }
            finally {
                ViewUtil.doneViewCreation();
            }
        }
    }

    private final class WriteAccessHandler
    implements IRepository.WriteAccessHandler {
        private WriteAccessHandler() {
        }

        public void handleTransactionBeforeCommitting(ITransaction transaction, final IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            if (transaction.getSessionID() == SecurityManager.this.session.getSessionID()) {
                return;
            }
            CDOBranchPoint securityContext = commitContext.getBranchPoint();
            String userID = commitContext.getUserID();
            User user = SecurityManager.this.getUser(userID);
            SecurityManager.this.handleCommit(commitContext, user);
            ViewUtil.initViewCreation((ViewCreator)new ViewCreator(){

                public CDOView createView(CDORevisionProvider revisionProvider) {
                    return CDOServerUtil.openView((IStoreAccessor.CommitContext)commitContext);
                }
            });
            try {
                this.permissionRevisionsBeforeCommitting(commitContext, securityContext, user, commitContext.getNewObjects());
                this.permissionRevisionsBeforeCommitting(commitContext, securityContext, user, commitContext.getDirtyObjects());
            }
            finally {
                ViewUtil.doneViewCreation();
            }
        }

        private void permissionRevisionsBeforeCommitting(IStoreAccessor.CommitContext commitContext, CDOBranchPoint securityContext, User user, InternalCDORevision[] revisions) {
            ISession session = commitContext.getTransaction().getSession();
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                CDOPermission permission = SecurityManager.this.getPermission((CDORevision)revision, (CDORevisionProvider)commitContext, securityContext, session, user);
                if (permission != CDOPermission.WRITE) {
                    throw new SecurityException("User " + user + " is not allowed to write to " + revision);
                }
                ++n2;
            }
        }

        @Deprecated
        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        }
    }
}

