/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.admin;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.admin.CDOAdminClientManager;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.common.admin.CDOAdminRepository;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistryPopulator;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.ui.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.ui.Net4jItemProvider;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOAdminView
extends ContainerView {
    public static final String ID = "org.eclipse.emf.cdo.ui.admin.CDOAdminView";
    private final CDOAdminClientManager adminManager = OM.getAdminManager();
    private Image connectionImage = org.eclipse.net4j.ui.shared.SharedIcons.getImage((String)"obj16/connector");
    private Image repositoryImage = SharedIcons.getImage((String)"obj16/repo.gif");
    private IAction addConnectionAction;
    private static int lastSessionNumber;

    protected IContainer<?> getContainer() {
        return this.adminManager;
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new ContainerItemProvider<IContainer<Object>>(){

            public String getText(Object obj) {
                if (obj instanceof CDOAdminClient) {
                    CDOAdminClient connection = (CDOAdminClient)obj;
                    return connection.getURL();
                }
                if (obj instanceof CDOAdminRepository) {
                    CDOAdminRepository repository = (CDOAdminRepository)obj;
                    return String.valueOf(repository.getName()) + " [" + repository.getType() + ", " + repository.getState() + "]";
                }
                return super.getText(obj);
            }

            public Image getImage(Object obj) {
                if (obj instanceof CDOAdminClient) {
                    return CDOAdminView.this.connectionImage;
                }
                if (obj instanceof CDOAdminRepository) {
                    return CDOAdminView.this.repositoryImage;
                }
                return super.getImage(obj);
            }

            public Font getFont(Object obj) {
                if (this.isDisabled(obj)) {
                    return this.getItalicFont();
                }
                return super.getFont(obj);
            }

            public Color getForeground(Object obj) {
                if (this.isDisabled(obj)) {
                    return this.getDisplay().getSystemColor(15);
                }
                return super.getForeground(obj);
            }

            private boolean isDisabled(Object obj) {
                if (obj instanceof CDOAdminClient) {
                    CDOAdminClient admin = (CDOAdminClient)obj;
                    return !admin.isConnected();
                }
                return false;
            }
        };
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        super.fillContextMenu(manager, selection);
        if (selection.size() == 1) {
            Object obj = selection.getFirstElement();
            if (obj instanceof CDOAdminClient) {
                CDOAdminClient admin = (CDOAdminClient)obj;
                manager.add((IAction)new RemoveConnectionAction(this.adminManager, admin));
            } else if (obj instanceof CDOAdminClientRepository) {
                CDOAdminClientRepository repository = (CDOAdminClientRepository)obj;
                manager.add((IAction)new OpenSessionAction(repository));
            }
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.addConnectionAction == null) {
            this.addConnectionAction = new Action(){

                public void run() {
                    String lastURL = OM.getLastURL();
                    InputDialog dialog = new InputDialog(CDOAdminView.this.getShell(), this.getText(), "Enter the connection URL:", lastURL, null);
                    if (dialog.open() == 0) {
                        String url = dialog.getValue();
                        OM.setLastURL(url);
                        CDOAdminView.this.adminManager.addConnection(url);
                    }
                }
            };
            this.addConnectionAction.setText("Add Connection");
            this.addConnectionAction.setToolTipText("Add a new connection");
            this.addConnectionAction.setImageDescriptor(org.eclipse.net4j.ui.shared.SharedIcons.getDescriptor((String)"etool16/add"));
        }
        manager.add(this.addConnectionAction);
        super.fillLocalToolBar(manager);
    }

    protected IPasswordCredentialsProvider getCredentialsProvider() {
        String factoryType;
        String productGroup;
        IManagedContainer container = this.adminManager.getContainer();
        IPasswordCredentialsProvider credentialsProvider = (IPasswordCredentialsProvider)container.getElement(productGroup = "org.eclipse.net4j.util.security.credentialsProviders", factoryType = "interactive", null);
        if (credentialsProvider == null) {
            credentialsProvider = UIUtil.createInteractiveCredentialsProvider();
        }
        return credentialsProvider;
    }

    public static int getNextSessionNumber() {
        return ++lastSessionNumber;
    }

    public class OpenSessionAction
    extends LongRunningAction
    implements CDOAdminClientRepository.SessionConfigurator {
        private CDOAdminClientRepository repository;

        public OpenSessionAction(CDOAdminClientRepository repository) {
            super("Open Session", "Open a new session to this repository", SharedIcons.getDescriptor((String)"etool16/open_session.gif"));
            this.repository = repository;
        }

        public CDOAdminClientRepository getRepository() {
            return this.repository;
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            block5: {
                try {
                    CDONet4jSession session = this.repository.openSession((CDOAdminClientRepository.SessionConfigurator)this);
                    if (session != null) {
                        CDOPackageRegistryPopulator.populate((CDOPackageRegistry)session.getPackageRegistry());
                        IManagedContainer container = CDOAdminView.this.adminManager.getContainer();
                        String description = "session" + CDOAdminView.getNextSessionNumber();
                        container.putElement("org.eclipse.emf.cdo.sessions", "admin", description, (Object)session);
                    }
                }
                catch (RemoteException ex) {
                    if (!(ex.getCause() instanceof NotAuthenticatedException)) {
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof NotAuthenticatedException) break block5;
                    throw ex;
                }
            }
        }

        public void prepare(CDONet4jSessionConfiguration configuration) {
            IPasswordCredentialsProvider credentialsProvider = CDOAdminView.this.getCredentialsProvider();
            configuration.setCredentialsProvider(credentialsProvider);
        }
    }

    public static class RemoveConnectionAction
    extends Net4jItemProvider.RemoveAction {
        private CDOAdminClientManager adminManager;

        public RemoveConnectionAction(CDOAdminClientManager adminManager, CDOAdminClient admin) {
            super((Object)admin);
            this.adminManager = adminManager;
        }

        public CDOAdminClientManager getAdminManager() {
            return this.adminManager;
        }

        public CDOAdminClient getObject() {
            return (CDOAdminClient)super.getObject();
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            this.adminManager.removeConnection(this.getObject());
        }
    }
}

