/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.ide.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.cdo.internal.team.RepositoryManager;
import org.eclipse.emf.cdo.internal.team.RepositoryTeamProvider;
import org.eclipse.emf.cdo.ui.internal.ide.bundle.OM;
import org.eclipse.emf.cdo.ui.internal.ide.messages.Messages;
import org.eclipse.emf.cdo.ui.internal.ide.wizards.CDOShareProjectWizardPage;
import org.eclipse.emf.cdo.ui.widgets.SessionComposite;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;

public class TeamConfigurationWizard
extends Wizard
implements IConfigurationWizard {
    private IProject project;
    private CDOShareProjectWizardPage page1;

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
        this.setWindowTitle(Messages.getString("TeamConfigurationWizard_1"));
        ImageDescriptor desc = OM.getImageDescriptor("icons/full/wizban/wizard_icon.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void addPages() {
        this.page1 = new CDOShareProjectWizardPage("page1");
        this.page1.setTitle(Messages.getString("TeamConfigurationWizard_2"));
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        try {
            SessionComposite sessionComposite = this.page1.getSessionComposite();
            String sessionDescription = sessionComposite.getSessionDescription();
            sessionComposite.rememberSettings();
            RepositoryTeamProvider.mapProject((IProject)this.project, (String)sessionDescription);
            RepositoryManager.INSTANCE.addElement(this.project);
            return true;
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            return false;
        }
    }
}

