/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.team.history;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionCommentator;
import org.eclipse.emf.cdo.ui.widgets.CommitHistoryComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;

public class CDOHistoryPage
extends HistoryPage {
    private static final String POPUP_ID = "org.eclipse.emf.cdo.ui.team.historyPageContributions";
    private CommitHistoryComposite commitHistoryComposite;
    private boolean commitOnDoubleClick;
    private CommitHistoryComposite.Input input;
    private IListener inputListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            if (!CDOHistoryPage.this.commitHistoryComposite.isDisposed()) {
                CDOHistoryPage.this.commitHistoryComposite.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CDOHistoryPage.this.setInput(null);
                    }
                });
            }
        }
    };

    public String getName() {
        return this.input != null ? this.input.toString() : null;
    }

    public String getDescription() {
        return "";
    }

    public CommitHistoryComposite getControl() {
        return this.commitHistoryComposite;
    }

    public void createControl(Composite parent) {
        this.commitHistoryComposite = new CommitHistoryComposite(parent, 0){

            protected void doubleClicked(CDOCommitInfo commitInfo) {
                if (CDOHistoryPage.this.commitOnDoubleClick) {
                    this.testCommit(commitInfo);
                }
            }

            private void testCommit(CDOCommitInfo commitInfo) {
                block6: {
                    CDOTransaction transaction = null;
                    try {
                        try {
                            CDOSession session = CDOHistoryPage.this.input.getSession();
                            CDOBranch branch = commitInfo.getBranch();
                            final long[] lastCommitTime = new long[1];
                            CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
                            commitInfoManager.getCommitInfos(branch, Long.MAX_VALUE, null, null, -1, new CDOCommitInfoHandler(){

                                public void handleCommitInfo(CDOCommitInfo commitInfo) {
                                    lastCommitTime[0] = commitInfo.getTimeStamp();
                                }
                            });
                            long timeStamp = commitInfo.getTimeStamp();
                            if (timeStamp != lastCommitTime[0]) {
                                String name = "branch-" + (timeStamp - session.getRepositoryInfo().getCreationTime()) / 1000L;
                                branch = branch.createBranch(name, timeStamp);
                            }
                            transaction = session.openTransaction(branch);
                            new CDOTransactionCommentator(transaction);
                            CDOResourceFolder folder = transaction.getOrCreateResourceFolder("test");
                            folder.addResource("resource-" + folder.getNodes().size());
                            transaction.commit();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            LifecycleUtil.deactivate(transaction);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        LifecycleUtil.deactivate(transaction);
                        throw throwable;
                    }
                    LifecycleUtil.deactivate((Object)transaction);
                }
            }
        };
        IPageSite site = this.getSite();
        TableViewer tableViewer = this.commitHistoryComposite.getTableViewer();
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        site.registerContextMenu(POPUP_ID, menuManager, (ISelectionProvider)tableViewer);
        site.setSelectionProvider((ISelectionProvider)tableViewer);
        IActionBars actionBars = site.getActionBars();
        this.setupToolBar(actionBars.getToolBarManager());
        this.setupViewMenu(actionBars.getMenuManager());
    }

    public void setFocus() {
        this.commitHistoryComposite.setFocus();
    }

    public void refresh() {
        this.commitHistoryComposite.refreshLayout();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isValidInput(Object object) {
        return CDOHistoryPage.canShowHistoryFor(object);
    }

    public boolean inputSet() {
        if (this.input != null) {
            this.input.removeListener(this.inputListener);
            this.input.deactivate();
            this.input = null;
        }
        Object object = this.getInput();
        try {
            this.input = new CommitHistoryComposite.Input(object);
            this.input.addListener(this.inputListener);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
        finally {
            this.commitHistoryComposite.setInput(this.input);
        }
    }

    public void dispose() {
        if (this.input != null) {
            this.input.deactivate();
            this.input = null;
        }
        super.dispose();
    }

    protected void setupToolBar(IToolBarManager manager) {
    }

    protected void setupViewMenu(IMenuManager manager) {
        manager.add((IAction)new Action("Format Time Stamps", 32){
            {
                CommitHistoryComposite.LabelProvider labelProvider = CDOHistoryPage.this.commitHistoryComposite.getLabelProvider();
                this.setChecked(labelProvider.isFormatTimeStamps());
            }

            public void run() {
                CommitHistoryComposite.LabelProvider labelProvider;
                labelProvider.setFormatTimeStamps(!(labelProvider = CDOHistoryPage.this.commitHistoryComposite.getLabelProvider()).isFormatTimeStamps());
                TableViewer tableViewer = CDOHistoryPage.this.commitHistoryComposite.getTableViewer();
                tableViewer.refresh(true);
            }
        });
        manager.add((IAction)new Action("Test Commit on Double Click", 32){

            public void run() {
                CDOHistoryPage.this.commitOnDoubleClick = !CDOHistoryPage.this.commitOnDoubleClick;
            }
        });
    }

    public static boolean canShowHistoryFor(Object object) {
        if (object == null) {
            return false;
        }
        try {
            new CommitHistoryComposite.Input(object);
            return true;
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }
}

