/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.transfer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.spi.repository.RepositoryTransferSystem;
import org.eclipse.emf.cdo.transfer.spi.ui.TransferUIProvider;
import org.eclipse.emf.cdo.transfer.ui.TransferDialog;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewRegistry;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.IDropActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryPluginDropAdapter
implements IDropActionDelegate {
    public static final String DROP_ACTION_ID = "org.eclipse.emf.cdo.ui.RepositoryPluginDropAdapter";
    private TransferUIProvider[] uiProviders = this.getUIProviders();

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected TransferUIProvider[] getUIProviders() {
        return TransferUIProvider.Factory.getAll((IManagedContainer)this.getContainer());
    }

    public boolean run(Object source, Object target) {
        List<CDOResourceNode> nodes = this.getResourceNodes(source);
        if (ObjectUtil.isEmpty(nodes)) {
            return false;
        }
        CDOView view = nodes.get(0).cdoView();
        RepositoryTransferSystem sourceSystem = new RepositoryTransferSystem(view);
        ArrayList<CDOTransferElement> sourceElements = new ArrayList<CDOTransferElement>(nodes.size());
        for (CDOResourceNode node : nodes) {
            sourceElements.add(sourceSystem.getElement(node.getPath()));
        }
        CDOTransferElement targetElement = this.getTargetElement(target);
        if (targetElement == null || !targetElement.isDirectory()) {
            return false;
        }
        Shell shell = new Shell();
        return TransferDialog.open((Shell)shell, sourceElements, (CDOTransferElement)targetElement);
    }

    protected CDOTransferElement getTargetElement(Object target) {
        TransferUIProvider[] transferUIProviderArray = this.uiProviders;
        int n = this.uiProviders.length;
        int n2 = 0;
        while (n2 < n) {
            TransferUIProvider uiProvider = transferUIProviderArray[n2];
            CDOTransferElement targetElement = uiProvider.convertTransferTarget(target);
            if (targetElement != null) {
                return targetElement;
            }
            ++n2;
        }
        return null;
    }

    protected List<CDOResourceNode> getResourceNodes(Object source) {
        CDOView view;
        ExtendedDataInputStream in;
        block4: {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])source);
            in = new ExtendedDataInputStream((InputStream)bais);
            int viewID = in.readInt();
            view = CDOViewRegistry.INSTANCE.getView(viewID);
            if (view != null) break block4;
            return null;
        }
        try {
            String path;
            ArrayList<CDOResourceNode> nodes = new ArrayList<CDOResourceNode>();
            while ((path = in.readString()) != null) {
                CDOResourceNode node = view.getResourceNode(path);
                if (node == null) continue;
                nodes.add(node);
            }
            return nodes;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }
}

