/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.workspace;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspaceBase;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler3;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSessionConfiguration;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOWorkspaceImpl
extends Notifier
implements InternalCDOWorkspace {
    private static final String PROP_BRANCH_PATH = "org.eclipse.emf.cdo.workspace.branchPath";
    private static final String PROP_TIME_STAMP = "org.eclipse.emf.cdo.workspace.timeStamp";
    private static final String PROP_FIXED = "org.eclipse.emf.cdo.workspace.fixed";
    private IManagedContainer container;
    private InternalCDOWorkspaceBase base;
    private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
    private CDOIDGenerator idGenerator;
    private InternalRepository localRepository;
    private InternalCDOSession localSession;
    private CDOBranchPoint head;
    private String branchPath;
    private long timeStamp;
    private boolean fixed;
    private boolean dirty;
    private CDOSessionConfigurationFactory remoteSessionConfigurationFactory;
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();

    public CDOWorkspaceImpl(String localRepositoryName, IStore local, CDOCommonRepository.IDGenerationLocation idGenerationLocation, CDOIDGenerator idGenerator, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote, String branchPath, long timeStamp) {
        this.init(localRepositoryName, local, idGenerationLocation, idGenerator, base, remote);
        this.branchPath = StringUtil.isEmpty((String)branchPath) ? "MAIN" : branchPath;
        this.timeStamp = timeStamp;
        this.fixed = timeStamp != 0L;
        this.checkout();
        this.saveProperties();
    }

    public CDOWorkspaceImpl(String localRepositoryName, IStore local, CDOCommonRepository.IDGenerationLocation idGenerationLocation, CDOIDGenerator idGenerator, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        this.init(localRepositoryName, local, idGenerationLocation, idGenerator, base, remote);
        this.loadProperties();
    }

    protected void init(String localRepositoryName, IStore local, CDOCommonRepository.IDGenerationLocation idGenerationLocation, CDOIDGenerator idGenerator, InternalCDOWorkspaceBase base, CDOSessionConfigurationFactory remote) {
        this.idGenerationLocation = idGenerationLocation;
        this.idGenerator = idGenerator;
        this.container = this.createContainer(local);
        this.remoteSessionConfigurationFactory = remote;
        this.localRepository = this.createLocalRepository(localRepositoryName, local);
        this.base = base;
        this.base.init(this);
        this.setDirtyFromBase();
    }

    private void setDirtyFromBase() {
        this.setDirty(!this.base.isEmpty());
    }

    protected void checkout() {
        Monitor monitor = new Monitor();
        final IStoreAccessor.Raw accessor = this.getLocalWriter(null);
        StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        try {
            InternalCDOSession remoteSession = this.openRemoteSession();
            try {
                this.localRepository.setRootResourceID(remoteSession.getRepositoryInfo().getRootResourceID());
                InternalCDOPackageUnit[] packageUnits = remoteSession.getPackageRegistry().getPackageUnits(false);
                this.localRepository.getPackageRegistry(false).putPackageUnits(packageUnits, CDOPackageUnit.State.LOADED);
                accessor.rawStore(packageUnits, (OMMonitor)monitor);
                CDORevisionHandler handler = new CDORevisionHandler((OMMonitor)monitor){
                    private final /* synthetic */ OMMonitor val$monitor;
                    {
                        this.val$monitor = oMMonitor;
                    }

                    public boolean handleRevision(CDORevision revision) {
                        InternalCDORevision rev = (InternalCDORevision)revision;
                        CDOWorkspaceImpl.this.adjustRevisionBranch(rev);
                        accessor.rawStore(rev, this.val$monitor);
                        long commitTime = revision.getTimeStamp();
                        if (commitTime > CDOWorkspaceImpl.this.timeStamp) {
                            CDOWorkspaceImpl.this.timeStamp = commitTime;
                        }
                        return true;
                    }
                };
                InternalCDOBranch branch = remoteSession.getBranchManager().getBranch(this.branchPath);
                remoteSession.getSessionProtocol().handleRevisions(null, (CDOBranch)branch, false, this.timeStamp, false, handler);
            }
            finally {
                LifecycleUtil.deactivate((Object)remoteSession);
            }
            accessor.rawCommit(1.0, (OMMonitor)monitor);
        }
        finally {
            StoreThreadLocal.release();
            monitor.done();
        }
    }

    @Override
    public String getBranchPath() {
        return this.branchPath;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.fireEvent(new DirtyStateChangedEventImpl(this, dirty));
        }
    }

    protected void clearBase() {
        this.base.clear();
        this.setDirty(false);
    }

    @Override
    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return this.idGenerationLocation;
    }

    public CDOIDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    @Override
    public InternalCDOWorkspaceBase getBase() {
        return this.base;
    }

    public InternalCDOView openView() {
        CDOView view = this.getLocalSession().openView();
        this.initView(view);
        return (InternalCDOView)view;
    }

    public InternalCDOView openView(ResourceSet resourceSet) {
        CDOView view = this.getLocalSession().openView(resourceSet);
        this.initView(view);
        return (InternalCDOView)view;
    }

    public InternalCDOTransaction openTransaction() {
        CDOTransaction transaction = this.getLocalSession().openTransaction();
        this.initView((CDOView)transaction);
        this.initTransaction(transaction);
        return (InternalCDOTransaction)transaction;
    }

    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        CDOTransaction transaction = this.getLocalSession().openTransaction(resourceSet);
        this.initView((CDOView)transaction);
        this.initTransaction(transaction);
        return (InternalCDOTransaction)transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initView(CDOView view) {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            this.views.add((InternalCDOView)view);
        }
        view.addListener((IListener)new ViewAdapter());
        if (view instanceof CDOTransaction) {
            if (this.fixed) {
                throw new ReadOnlyException("Workspace is fixed");
            }
            if (this.idGenerationLocation != CDOCommonRepository.IDGenerationLocation.CLIENT) {
                CDOTransaction transaction = (CDOTransaction)view;
                transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler1(){

                    public void attachingObject(CDOTransaction transaction, CDOObject object) {
                        throw new IllegalStateException("Attaching new objects is only supported for IDGenerationLocation.CLIENT");
                    }
                });
            }
        }
    }

    protected void initTransaction(CDOTransaction transaction) {
        transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler2(){

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                CDOID id;
                InternalCDOTransaction tx = (InternalCDOTransaction)transaction;
                Set dirtyObjects = tx.getDirtyObjects().keySet();
                Set detachedObjects = tx.getDetachedObjects().keySet();
                for (InternalCDORevision revision : tx.getCleanRevisions().values()) {
                    id = revision.getID();
                    boolean isDetached = detachedObjects.contains(id);
                    if (isDetached && CDOWorkspaceImpl.this.base.isAddedObject(id)) {
                        CDOWorkspaceImpl.this.base.deregisterObject(id);
                    }
                    if (!dirtyObjects.contains(id) && !isDetached) continue;
                    CDOWorkspaceImpl.this.base.registerChangedOrDetachedObject(revision);
                }
                for (CDOObject object : tx.getNewObjects().values()) {
                    id = object.cdoID();
                    CDOWorkspaceImpl.this.base.registerAddedObject(id);
                }
                CDOWorkspaceImpl.this.setDirtyFromBase();
            }
        });
    }

    public InternalCDOTransaction update(CDOMerger merger) {
        return this.merge(merger, this.branchPath);
    }

    public InternalCDOTransaction merge(CDOMerger merger, String branchPath) {
        return this.merge(merger, branchPath, 0L);
    }

    public InternalCDOTransaction merge(CDOMerger merger, String branchPath, long timeStamp) {
        final InternalCDOSession remoteSession = this.openRemoteSession();
        if (timeStamp == 0L) {
            timeStamp = remoteSession.getLastUpdateTime();
        }
        final long newTimeStamp = timeStamp;
        InternalCDOBranchManager branchManager = remoteSession.getBranchManager();
        CDOBranchPoint basePoint = branchManager.getBranch(branchPath).getPoint(this.timeStamp);
        final CDOBranchPoint remotePoint = branchManager.getBranch(branchPath).getPoint(newTimeStamp);
        CDOBranchPointRange range = CDOBranchUtil.createRange((CDOBranchPoint)basePoint, (CDOBranchPoint)remotePoint);
        final CDOChangeSetData remoteData = remoteSession.getSessionProtocol().loadChangeSets(new CDOBranchPointRange[]{range})[0];
        CDOChangeSetData localData = this.getLocalChanges();
        CDOChangeSetData result = this.getMergeResult(merger, basePoint, remotePoint, localData, remoteData);
        InternalCDOTransaction transaction = (InternalCDOTransaction)this.getLocalSession().openTransaction();
        this.initView((CDOView)transaction);
        transaction.applyChangeSet(result, (CDORevisionProvider)new BaseRevisionProvider(), (CDORevisionProvider)this, null, false);
        transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler3(){

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext, CDOCommitInfo result) {
                try {
                    Set<CDOID> affectedIDs = this.getAffectedIDs(commitContext, remoteData);
                    CDOWorkspaceImpl local = CDOWorkspaceImpl.this;
                    ManagedRevisionProvider remote = new ManagedRevisionProvider((CDORevisionManager)remoteSession.getRevisionManager(), remotePoint);
                    this.updateBase(affectedIDs, local, (CDORevisionProvider)remote);
                    CDOWorkspaceImpl.this.setTimeStamp(newTimeStamp);
                }
                finally {
                    LifecycleUtil.deactivate((Object)remoteSession);
                }
            }

            private void updateBase(Set<CDOID> affectedIDs, CDORevisionProvider local, CDORevisionProvider remote) {
                for (CDOID id : affectedIDs) {
                    CDORevision localRevision = this.getRevision(id, local);
                    CDORevision remoteRevision = this.getRevision(id, remote);
                    if (localRevision == null) {
                        if (remoteRevision == null) {
                            CDOWorkspaceImpl.this.base.deregisterObject(id);
                            continue;
                        }
                        CDOWorkspaceImpl.this.base.registerChangedOrDetachedObject((InternalCDORevision)remoteRevision);
                        continue;
                    }
                    if (remoteRevision == null) {
                        CDOWorkspaceImpl.this.base.registerAddedObject(id);
                        continue;
                    }
                    CDORevisionDelta delta = localRevision.compare(remoteRevision);
                    if (delta.isEmpty()) {
                        CDOWorkspaceImpl.this.base.deregisterObject(id);
                        continue;
                    }
                    CDOWorkspaceImpl.this.base.registerChangedOrDetachedObject((InternalCDORevision)remoteRevision);
                }
            }

            private Set<CDOID> getAffectedIDs(CDOCommitContext commitContext, CDOChangeSetData remoteData2) {
                HashSet<CDOID> affectedIDs = new HashSet<CDOID>();
                affectedIDs.addAll(CDOWorkspaceImpl.this.base.getIDs());
                affectedIDs.addAll(remoteData2.getChangeKinds().keySet());
                affectedIDs.addAll(commitContext.getNewObjects().keySet());
                affectedIDs.addAll(commitContext.getDirtyObjects().keySet());
                affectedIDs.addAll(commitContext.getDetachedObjects().keySet());
                return affectedIDs;
            }

            private CDORevision getRevision(CDOID id, CDORevisionProvider revisionProvider) {
                CDORevision revision = revisionProvider.getRevision(id);
                if (revision instanceof DetachedCDORevision) {
                    revision = null;
                }
                return revision;
            }
        });
        return transaction;
    }

    private CDOChangeSetData getMergeResult(CDOMerger merger, CDOBranchPoint basePoint, CDOBranchPoint remotePoint, CDOChangeSetData localData, CDOChangeSetData remoteData) {
        if (localData.isEmpty()) {
            return remoteData;
        }
        CDOChangeSet localChanges = CDORevisionUtil.createChangeSet((CDOBranchPoint)basePoint, null, (CDOChangeSetData)localData);
        CDOChangeSet remoteChanges = CDORevisionUtil.createChangeSet((CDOBranchPoint)basePoint, (CDOBranchPoint)remotePoint, (CDOChangeSetData)remoteData);
        return merger.merge(localChanges, remoteChanges);
    }

    @Override
    public void revert() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replace(String branchPath, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDOCommitInfo checkin() throws CommitException {
        return this.checkin(null);
    }

    @Override
    public CDOCommitInfo checkin(String comment) throws CommitException {
        InternalCDOSession remoteSession = this.openRemoteSession();
        try {
            InternalCDOBranch branch = remoteSession.getBranchManager().getBranch(this.branchPath);
            InternalCDOTransaction transaction = (InternalCDOTransaction)remoteSession.openTransaction((CDOBranch)branch);
            CDOChangeSetData changes = this.getLocalChanges();
            try {
                InternalCDOTransaction.ApplyChangeSetResult result = transaction.applyChangeSet(changes, (CDORevisionProvider)this.base, (CDORevisionProvider)this, this.head, true);
                if (!result.getIDMappings().isEmpty()) {
                    throw new IllegalStateException("Attaching new objects is only supported for IDGenerationLocation.CLIENT");
                }
            }
            catch (InternalCDOTransaction.ChangeSetOutdatedException ex) {
                throw new CommitException((Throwable)ex);
            }
            transaction.setCommitComment(comment);
            CDOCommitInfo info = transaction.commit();
            this.adjustLocalRevisions(transaction, info);
            this.clearBase();
            this.setTimeStamp(info.getTimeStamp());
            CDOCommitInfo cDOCommitInfo = info;
            return cDOCommitInfo;
        }
        finally {
            LifecycleUtil.deactivate((Object)remoteSession);
        }
    }

    protected void adjustLocalRevisions(InternalCDOTransaction transaction, CDOCommitInfo info) {
        IStoreAccessor.Raw accessor = null;
        for (CDORevisionKey key : info.getChangedObjects()) {
            CDOID id = key.getID();
            InternalCDORevision localRevision = (InternalCDORevision)this.getRevision(id);
            CDORevision baseRevision = this.base.getRevision(id);
            CDORevision remoteRevision = transaction.getObject(id).cdoRevision();
            CDOBranch localBranch = this.head.getBranch();
            EClass eClass = localRevision.getEClass();
            int v = baseRevision.getVersion();
            while (v < localRevision.getVersion()) {
                if (accessor == null) {
                    accessor = this.getLocalWriter(null);
                    StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
                }
                accessor.rawDelete(id, v, localBranch, eClass, (OMMonitor)new Monitor());
                ++v;
            }
            if (localRevision.getVersion() == remoteRevision.getVersion()) continue;
            if (accessor == null) {
                accessor = this.getLocalWriter(null);
                StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
            }
            accessor.rawDelete(id, localRevision.getVersion(), localBranch, eClass, (OMMonitor)new Monitor());
            localRevision.setVersion(remoteRevision.getVersion());
            this.adjustRevisionBranch(localRevision);
            accessor.rawStore(localRevision, (OMMonitor)new Monitor());
        }
        if (accessor != null) {
            accessor.rawCommit(1.0, (OMMonitor)new Monitor());
            StoreThreadLocal.release();
            this.localRepository.getRevisionManager().getCache().clear();
            this.localSession.getRevisionManager().getCache().clear();
        }
    }

    private void adjustRevisionBranch(InternalCDORevision revision) {
        InternalCDOBranchManager branchManager = this.localRepository.getBranchManager();
        InternalCDOBranch branch = revision.getBranch();
        if (branch.getBranchManager() != branchManager) {
            branch = branchManager.getBranch(branch.getID());
            revision.setBranchPoint(branch.getPoint(revision.getTimeStamp()));
        }
    }

    @Deprecated
    protected CDOIDMapper getIDMapper(InternalCDOTransaction transaction, final Map<CDOID, CDOID> idMappings) {
        if (idMappings.isEmpty()) {
            return null;
        }
        transaction.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof CDOTransactionFinishedEvent) {
                    CDOTransactionFinishedEvent e = (CDOTransactionFinishedEvent)event;
                    Map remoteMappings = e.getIDMappings();
                    for (Map.Entry entry : idMappings.entrySet()) {
                        CDOID tempID = (CDOID)entry.getValue();
                        CDOID newID = (CDOID)remoteMappings.get(tempID);
                        entry.setValue(newID);
                    }
                }
            }
        });
        return new CDOIDMapper(idMappings);
    }

    @Deprecated
    protected void adjustLocalIDs(CDOIDMapper idMapper, List<CDOID> adjustedObjects) {
        Map idMappings = idMapper.getIDMappings();
        if (!idMappings.isEmpty()) {
            CDOTransaction transaction = null;
            Monitor monitor = new Monitor();
            try {
                transaction = this.localSession.openTransaction();
                InternalSession repoSession = this.localRepository.getSessionManager().getSession(this.localSession.getSessionID());
                ITransaction repoTransaction = (ITransaction)repoSession.getView(transaction.getViewID());
                IStoreAccessor.Raw accessor = this.getLocalWriter(repoTransaction);
                StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
                monitor.begin((double)(idMappings.size() * 2 + adjustedObjects.size() * 2 + 10));
                for (Map.Entry entry : idMappings.entrySet()) {
                    CDOID id = (CDOID)entry.getKey();
                    InternalCDORevision revision = accessor.readRevision(id, this.head, -1, null);
                    int version = revision.getVersion();
                    InternalCDOBranch branch = revision.getBranch();
                    EClass eClass = revision.getEClass();
                    CDOID newID = (CDOID)entry.getValue();
                    revision.setID(newID);
                    revision.setVersion(1);
                    accessor.rawDelete(id, version, (CDOBranch)branch, eClass, monitor.fork());
                    revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                    accessor.rawStore(revision, monitor.fork());
                }
                for (CDOID id : adjustedObjects) {
                    InternalCDORevision revision = accessor.readRevision(id, this.head, -1, null);
                    int version = revision.getVersion();
                    InternalCDOBranch branch = revision.getBranch();
                    EClass eClass = revision.getEClass();
                    accessor.rawDelete(id, version, (CDOBranch)branch, eClass, monitor.fork());
                    revision.adjustReferences((CDOReferenceAdjuster)idMapper);
                    accessor.rawStore(revision, monitor.fork());
                }
                accessor.rawCommit(1.0, monitor.fork(10.0));
            }
            finally {
                monitor.done();
                StoreThreadLocal.release();
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }

    @Override
    public CDOChangeSetData compare(String branchPath) {
        return this.compare(branchPath, 0L);
    }

    @Override
    public CDOChangeSetData compare(String branchPath, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public synchronized void close() {
        LifecycleUtil.deactivate((Object)this.localSession);
        this.localSession = null;
        LifecycleUtil.deactivate((Object)this.localRepository);
        this.localRepository = null;
        LifecycleUtil.deactivate((Object)this.container);
        this.container = null;
    }

    public synchronized boolean isClosed() {
        return this.container == null;
    }

    public CDORevision getRevision(CDOID id) {
        InternalCDOSession session = this.getLocalSession();
        InternalCDORevisionManager revisionManager = session.getRevisionManager();
        return revisionManager.getRevision(id, this.head, -1, 0, true);
    }

    @Override
    public InternalRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public synchronized InternalCDOSession getLocalSession() {
        if (this.localSession == null) {
            this.localSession = this.openLocalSession();
        }
        return this.localSession;
    }

    @Override
    public CDOChangeSetData getLocalChanges() {
        Set<CDOID> ids = this.base.getIDs();
        return CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)this.base, (CDORevisionProvider)this, (boolean)true);
    }

    @Override
    public CDOSessionConfigurationFactory getRemoteSessionConfigurationFactory() {
        return this.remoteSessionConfigurationFactory;
    }

    protected IManagedContainer createContainer(IStore local) {
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        JVMUtil.prepareContainer((IManagedContainer)container);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        return container;
    }

    protected IManagedContainer getContainer() {
        return this.container;
    }

    protected String getLocalAcceptorName() {
        return "acceptor-for-" + this.localRepository.getUUID();
    }

    protected IJVMAcceptor getLocalAcceptor() {
        String localAcceptorName = this.getLocalAcceptorName();
        return JVMUtil.getAcceptor((IManagedContainer)this.container, (String)localAcceptorName);
    }

    protected IJVMConnector getLocalConnector() {
        String localAcceptorName = this.getLocalAcceptorName();
        return JVMUtil.getConnector((IManagedContainer)this.container, (String)localAcceptorName);
    }

    protected IStoreAccessor.Raw getLocalWriter(ITransaction transaction) {
        return (IStoreAccessor.Raw)this.localRepository.getStore().getWriter(transaction);
    }

    protected InternalRepository createLocalRepository(String localRepositoryName, IStore store) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", "false");
        props.put("supportingBranches", "false");
        props.put("idGenerationLocation", this.idGenerationLocation.toString());
        Repository.Default repository = new Repository.Default(){

            public void initMainBranch(InternalCDOBranchManager branchManager, long timeStamp) {
                if (CDOWorkspaceImpl.this.idGenerationLocation == CDOCommonRepository.IDGenerationLocation.STORE) {
                    branchManager.initMainBranch(true, timeStamp);
                } else {
                    super.initMainBranch(branchManager, timeStamp);
                }
            }

            protected void initRootResource() {
                this.setState(CDOCommonRepository.State.INITIAL);
            }
        };
        repository.setName(localRepositoryName);
        repository.setStore((InternalStore)store);
        repository.setProperties(props);
        CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)repository);
        return repository;
    }

    protected InternalCDOSession openLocalSession() {
        this.getLocalAcceptor();
        IJVMConnector connector = this.getLocalConnector();
        String repositoryName = this.localRepository.getName();
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector((IConnector)connector);
        configuration.setRepositoryName(repositoryName);
        configuration.setIDGenerator(this.idGenerator);
        configuration.setRevisionManager(CDORevisionUtil.createRevisionManager((CDORevisionCache)CDORevisionCache.NOOP));
        if (this.idGenerationLocation == CDOCommonRepository.IDGenerationLocation.STORE) {
            ((InternalCDOSessionConfiguration)configuration).setMainBranchLocal(true);
        }
        InternalCDOSession session = (InternalCDOSession)configuration.openNet4jSession();
        ((ISignalProtocol)session.getSessionProtocol()).setTimeout(-1L);
        session.setPackageRegistry(this.localRepository.getPackageRegistry(false));
        this.head = session.getBranchManager().getMainBranch().getHead();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalCDOView[] getViews() {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new InternalCDOView[this.views.size()]);
        }
    }

    protected InternalCDOSession openRemoteSession() {
        CDOSessionConfiguration configuration = this.remoteSessionConfigurationFactory.createSessionConfiguration();
        InternalCDOSession session = (InternalCDOSession)configuration.openSession();
        CDORepositoryInfo repositoryInfo = session.getRepositoryInfo();
        if (!repositoryInfo.isSupportingAudits()) {
            session.close();
            throw new IllegalStateException("Remote repository does not support auditing");
        }
        CDOCommonRepository.IDGenerationLocation remoteLocation = repositoryInfo.getIDGenerationLocation();
        if (!remoteLocation.equals((Object)this.idGenerationLocation)) {
            session.close();
            throw new IllegalStateException("Remote repository uses different ID generation location: " + remoteLocation);
        }
        return session;
    }

    protected void setTimeStamp(long timeStamp) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROP_TIME_STAMP, String.valueOf(timeStamp));
        this.localRepository.getStore().setPersistentProperties(props);
        this.timeStamp = timeStamp;
    }

    protected void saveProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROP_BRANCH_PATH, this.branchPath);
        props.put(PROP_TIME_STAMP, String.valueOf(this.timeStamp));
        props.put(PROP_FIXED, String.valueOf(this.fixed));
        this.localRepository.getStore().setPersistentProperties(props);
    }

    protected void loadProperties() {
        HashSet<String> names = new HashSet<String>(Arrays.asList(PROP_BRANCH_PATH, PROP_TIME_STAMP, PROP_FIXED));
        Map props = this.localRepository.getStore().getPersistentProperties(names);
        this.branchPath = (String)props.get(PROP_BRANCH_PATH);
        this.timeStamp = Long.parseLong((String)props.get(PROP_TIME_STAMP));
        this.fixed = Boolean.parseBoolean((String)props.get(PROP_FIXED));
    }

    private class BaseRevisionProvider
    implements CDORevisionProvider {
        private BaseRevisionProvider() {
        }

        public CDORevision getRevision(CDOID id) {
            CDORevision revision = CDOWorkspaceImpl.this.base.getRevision(id);
            if (revision == null) {
                revision = CDOWorkspaceImpl.this.getRevision(id);
            }
            return revision;
        }
    }

    private static final class DirtyStateChangedEventImpl
    extends Event
    implements CDOWorkspace.DirtyStateChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean dirty;

        public DirtyStateChangedEventImpl(CDOWorkspace workspace, boolean dirty) {
            super((INotifier)workspace);
            this.dirty = dirty;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }

    public final class ViewAdapter
    extends LifecycleEventAdapter {
        public CDOWorkspace getWorkspace() {
            return CDOWorkspaceImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDeactivated(ILifecycle view) {
            Set set = CDOWorkspaceImpl.this.views;
            synchronized (set) {
                CDOWorkspaceImpl.this.views.remove(view);
            }
        }
    }
}

