/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.importer;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimePlatform;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.importer.XcoreImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XcoreImporter
extends ModelImporter {
    protected ResourceSet resourceSet = new XtextResourceSet();

    public XcoreImporter() {
        this.resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
    }

    public String getID() {
        return "org.eclipse.emf.ecore.xcore.importer";
    }

    protected Diagnostic doComputeEPackages(Monitor monitor) throws Exception {
        BasicDiagnostic basicDiagnostic = null;
        List locationURIs = this.getModelLocationURIs();
        if (locationURIs.isEmpty()) {
            basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.converter", 264, XcoreImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidXcore_message"), null);
        } else {
            this.resourceSet.getResources().clear();
            monitor.beginTask("", 2);
            monitor.subTask(XcoreImporterPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{locationURIs}));
            for (URI locationURI : locationURIs) {
                Resource inputResource = this.resourceSet.getResource(locationURI, true);
                EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
                GenModel genModel = (GenModel)EcoreUtil.getObjectByType((Collection)inputResource.getContents(), (EClassifier)GenModelPackage.Literals.GEN_MODEL);
                EPackage ePackage = (EPackage)EcoreUtil.getObjectByType((Collection)inputResource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
                List ePackages = this.getEPackages();
                if (ePackage != null) {
                    inputResource.getContents().remove((Object)ePackage);
                    ePackages.add(ePackage);
                }
                EList usedGenPackages = genModel.getUsedGenPackages();
                for (GenPackage usedGenPackage : usedGenPackages) {
                    ePackages.add(usedGenPackage.getEcorePackage());
                }
                this.getReferencedGenPackages().addAll(usedGenPackages);
            }
        }
        if (basicDiagnostic == null) {
            return Diagnostic.OK_INSTANCE;
        }
        return basicDiagnostic;
    }

    protected void adjustGenModel(Monitor monitor) {
        super.adjustGenModel(monitor);
        IPath genModelFileFullPath = this.getGenModelPath();
        URI genModelURI = this.createFileURI(genModelFileFullPath.toString());
        for (URI uri : this.getModelLocationURIs()) {
            this.getGenModel().getForeignModel().add((Object)this.makeRelative(uri, genModelURI).toString());
        }
    }

    protected void handleOriginalGenModel() throws DiagnosticException {
        URI genModelURI = this.getOriginalGenModel().eResource().getURI();
        StringBuffer text = new StringBuffer();
        for (String value : this.getOriginalGenModel().getForeignModel()) {
            if (!value.endsWith(".xcore")) continue;
            text.append(this.makeAbsolute(URI.createURI((String)value), genModelURI).toString());
            text.append(" ");
        }
        this.setModelLocation(text.toString().trim());
    }

    public void prepareGenModelAndEPackages(Monitor monitor) {
        super.prepareGenModelAndEPackages(monitor);
        GenModel oldOriginalGenModel = this.originalGenModel;
        if (oldOriginalGenModel == null) {
            GenModel mainGenModel = this.getGenModel();
            for (Resource xcoreResource : this.resourceSet.getResources()) {
                GenModel genModel = (GenModel)EcoreUtil.getObjectByType((Collection)xcoreResource.getContents(), (EClassifier)GenModelPackage.Literals.GEN_MODEL);
                if (genModel == null || EcoreUtil.getObjectByType((Collection)xcoreResource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE) != null) continue;
                mainGenModel.reconcile(genModel);
            }
            GenRuntimePlatform runtimePlatform = mainGenModel.getRuntimePlatform();
            this.originalGenModel = null;
            this.adjustGenModel(monitor);
            this.originalGenModel = oldOriginalGenModel;
            mainGenModel.setRuntimePlatform(runtimePlatform);
        }
    }
}

