/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.quickfix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.util.MergeableManifest;
import org.osgi.framework.Bundle;

public class XcoreClasspathUpdater {
    private static final Logger LOG = Logger.getLogger(XcoreClasspathUpdater.class);
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    public void addBundle(IJavaProject javaProject, String bundleID, IProgressMonitor monitor) {
        try {
            URL entry;
            Bundle bundle;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            IProject project = javaProject.getProject();
            if (!(project.hasNature(PLUGIN_NATURE) && this.addBundleToManifest(project, bundleID, (IProgressMonitor)progress.newChild(1)) || (bundle = Platform.getBundle((String)bundleID)) == null || (entry = bundle.getEntry("/")) == null)) {
                URI uri = URI.createURI((String)FileLocator.resolve((URL)entry).toURI().toString());
                if (uri.isArchive()) {
                    String authority = uri.authority();
                    uri = URI.createURI((String)authority.substring(0, authority.length() - 1));
                }
                if (uri.isFile()) {
                    String location = uri.toFileString();
                    File binFolder = new File(location, "bin");
                    if (binFolder.isDirectory()) {
                        location = binFolder.toString();
                    }
                    this.addJarToClasspath(javaProject, (IPath)new Path(location), (IProgressMonitor)progress.newChild(1));
                }
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("Error adding '" + bundleID + "' to the classpath"), (Throwable)exception);
        }
    }

    protected boolean addJarToClasspath(IJavaProject javaProject, IPath location, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry newClasspthEntry = JavaCore.newLibraryEntry((IPath)location, null, null);
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        IClasspathEntry[] newRawClasspath = new IClasspathEntry[rawClasspath.length + 1];
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)location)) {
                return false;
            }
            newRawClasspath[i + 1] = entry;
            ++i;
        }
        newRawClasspath[0] = newClasspthEntry;
        javaProject.setRawClasspath(newRawClasspath, monitor);
        return true;
    }

    protected boolean addBundleToManifest(IProject project, String bundleID, IProgressMonitor monitor) throws IOException, CoreException {
        IResource manifestFile = project.findMember("META-INF/MANIFEST.MF");
        if (manifestFile != null && manifestFile.isAccessible() && !manifestFile.getResourceAttributes().isReadOnly() && manifestFile instanceof IFile) {
            OutputStream output = null;
            InputStream input = null;
            try {
                MergeableManifest manifest = new MergeableManifest(((IFile)manifestFile).getContents());
                manifest.addRequiredBundles(Collections.singleton(bundleID));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                output = new BufferedOutputStream(out);
                manifest.write(output);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                input = new BufferedInputStream(in);
                ((IFile)manifestFile).setContents(input, true, true, monitor);
                return true;
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
        }
        return false;
    }
}

