/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.resource;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.scoping.LazyCreationProxyURIConverter;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

public class XcoreResource
extends BatchLinkableResource {
    @Inject
    private LazyCreationProxyURIConverter proxyConverter;
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private IScopeProvider scopeProvider;
    private LinkedHashSet<Pair<EClass, QualifiedName>> resolving = Sets.newLinkedHashSet();
    protected FragmentCache fragmentCache;

    public synchronized EObject getEObject(String uriFragment) {
        EObject result;
        if (this.fragmentCache == null) {
            this.fragmentCache = new FragmentCache(this);
        }
        if ((result = this.fragmentCache.get(uriFragment)) != null) {
            return result;
        }
        Pair<EClass, QualifiedName> fragmentInfo = this.proxyConverter.decodeFragment(uriFragment);
        if (fragmentInfo != null) {
            try {
                EObject eObject = this.resolving.add(fragmentInfo) ? this.findEObject((EClass)fragmentInfo.getFirst(), (QualifiedName)fragmentInfo.getSecond(), uriFragment) : null;
                return eObject;
            }
            finally {
                this.resolving.remove(fragmentInfo);
            }
        }
        return super.getEObject(uriFragment);
    }

    protected EObject findEObject(EClass eClass, QualifiedName name, String uriFragment) {
        URI uri;
        IScope scope;
        IEObjectDescription eObjectDescription;
        if (!(eClass != TypesPackage.Literals.JVM_TYPE && eClass != GenModelPackage.Literals.GEN_CLASS && eClass != GenModelPackage.Literals.GEN_DATA_TYPE && eClass != GenModelPackage.Literals.GEN_ENUM || (eObjectDescription = (scope = this.scopeProvider.getScope((EObject)this.getContents().get(0), eClass == TypesPackage.Literals.JVM_TYPE ? TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE : XcorePackage.Literals.XGENERIC_TYPE__TYPE)).getSingleElement(name)) == null || uriFragment.equals((uri = eObjectDescription.getEObjectURI()).fragment()) && uri.trimFragment().equals(this.getURI()))) {
            return eObjectDescription.getEObjectOrProxy();
        }
        return null;
    }

    public String getURIFragment(EObject object) {
        QualifiedName qualifiedName;
        EClass eClass = object.eClass();
        if ((eClass == TypesPackage.Literals.JVM_ENUMERATION_TYPE || eClass == GenModelPackage.Literals.GEN_CLASS || eClass == GenModelPackage.Literals.GEN_DATA_TYPE || eClass == GenModelPackage.Literals.GEN_ENUM || eClass == TypesPackage.Literals.JVM_GENERIC_TYPE) && (qualifiedName = this.nameProvider.getFullyQualifiedName(object)) != null) {
            return this.proxyConverter.encodeFragment(eClass, qualifiedName);
        }
        return super.getURIFragment(object);
    }

    protected String getURIFragmentRootSegment(EObject eObject) {
        if (eObject instanceof EPackage) {
            return "EPackage";
        }
        return super.getURIFragmentRootSegment(eObject);
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        if ("EPackage".equals(uriFragmentRootSegment)) {
            return (EObject)EcoreUtil.getObjectByType((Collection)this.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        }
        return super.getEObjectForURIFragmentRootSegment(uriFragmentRootSegment);
    }

    protected class FragmentCache
    extends AdapterImpl {
        protected Map<String, EObject> map;
        protected int expectedSize;

        public FragmentCache(XcoreResource xcoreResource2) {
            XcoreResource.this.eAdapters().add((Object)this);
        }

        public EObject get(String uriFragment) {
            int actualSize = XcoreResource.this.getContents().size();
            if (this.map != null && this.expectedSize != actualSize) {
                this.clear();
            }
            if (this.map == null) {
                this.map = Maps.newHashMap();
                for (EObject eObject : XcoreResource.this.getContents()) {
                    this.buildEntry(eObject);
                }
                this.expectedSize = actualSize;
            }
            return this.map.get(uriFragment);
        }

        protected void buildEntry(EObject eObject) {
            block5: {
                block6: {
                    block4: {
                        eObject.eAdapters().add((Object)this);
                        this.map.put(XcoreResource.this.getURIFragment(eObject), eObject);
                        if (!(eObject instanceof GenModel)) break block4;
                        for (GenPackage genPackage : ((GenModel)eObject).getGenPackages()) {
                            this.buildEntry((EObject)genPackage);
                            for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
                                this.buildEntry((EObject)genClassifier);
                            }
                        }
                        break block5;
                    }
                    if (!(eObject instanceof EPackage)) break block6;
                    for (EClassifier eClassifier : ((EPackage)eObject).getEClassifiers()) {
                        this.buildEntry((EObject)eClassifier);
                    }
                    break block5;
                }
                if (!(eObject instanceof JvmDeclaredType)) break block5;
                for (JvmMember jvmMember : ((JvmDeclaredType)eObject).getMembers()) {
                    if (!(jvmMember instanceof JvmDeclaredType)) continue;
                    this.buildEntry((EObject)jvmMember);
                }
            }
        }

        public void notifyChanged(Notification notification) {
            Object feature;
            if (this.map != null && ((feature = notification.getFeature()) == null || feature == EcorePackage.Literals.ENAMED_ELEMENT__NAME || feature == TypesPackage.Literals.JVM_MEMBER__SIMPLE_NAME || feature == TypesPackage.Literals.JVM_DECLARED_TYPE__PACKAGE_NAME)) {
                this.clear();
            }
        }

        public void clear() {
            Collection<EObject> values = this.map.values();
            this.map = null;
            for (EObject eObject : values) {
                eObject.eAdapters().remove((Object)this);
            }
        }
    }
}

