/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.util;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.eclipse.emf.ecore.xcore.XAnnotation;
import org.eclipse.emf.ecore.xcore.XAnnotationDirective;
import org.eclipse.emf.ecore.xcore.XAttribute;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XClassifier;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XEnum;
import org.eclipse.emf.ecore.xcore.XEnumLiteral;
import org.eclipse.emf.ecore.xcore.XGenericType;
import org.eclipse.emf.ecore.xcore.XMember;
import org.eclipse.emf.ecore.xcore.XModelElement;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XParameter;
import org.eclipse.emf.ecore.xcore.XReference;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.XTypeParameter;
import org.eclipse.emf.ecore.xcore.XTypedElement;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.interpreter.IClassLoaderProvider;
import org.eclipse.emf.ecore.xcore.interpreter.XcoreConversionDelegate;
import org.eclipse.emf.ecore.xcore.interpreter.XcoreInterpreter;
import org.eclipse.emf.ecore.xcore.interpreter.XcoreInvocationDelegate;
import org.eclipse.emf.ecore.xcore.interpreter.XcoreSettingDelegate;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.emf.ecore.xcore.services.XcoreGrammarAccess;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.XBlockExpression;

public class XcoreEcoreBuilder {
    private static final Pattern COMMENT_LINE_BREAK_PATTERN = Pattern.compile("([ \t]*((\n\r?)|(\r\n?))(\\s*\\*\\s?)?)|\\s*$", 8);
    @Inject
    private XcoreMapper mapper;
    @Inject
    private Provider<XcoreInvocationDelegate> operationDelegateProvider;
    @Inject
    private Provider<XcoreSettingDelegate> settingDelegateProvider;
    @Inject
    private Provider<XcoreConversionDelegate> conversionDelegateProvider;
    @Inject
    private Provider<XcoreInterpreter> interpreterProvider;
    @Inject
    private IClassLoaderProvider classLoaderProvider;
    @Inject
    private XcoreGrammarAccess xcoreGrammarAccess;
    protected List<Runnable> runnables = new ArrayList<Runnable>();
    protected List<Runnable> instanceTypeRunnables = new ArrayList<Runnable>();
    protected XcoreInterpreter interpreter;
    protected ClassLoader classLoader;

    public void link() {
        ArrayList<Runnable> currentRunnables = new ArrayList<Runnable>(this.runnables);
        this.runnables.clear();
        for (Runnable runnable : currentRunnables) {
            runnable.run();
        }
        for (Runnable runnable : this.runnables) {
            runnable.run();
        }
    }

    public void linkInstanceTypes() {
        for (Runnable runnable : this.instanceTypeRunnables) {
            runnable.run();
        }
    }

    public static void setQualifiedPackageName(EPackage ePackage, String name) {
        String basePackage = null;
        if (name != null) {
            int index = name.lastIndexOf(".");
            if (index == -1) {
                basePackage = null;
                ePackage.setName(name);
            } else {
                basePackage = name.substring(0, index);
                ePackage.setName(name.substring(index + 1));
            }
        } else {
            ePackage.setName("_");
        }
        EcoreUtil.setAnnotation((EModelElement)ePackage, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"basePackage", basePackage);
    }

    protected String nonNullName(String name) {
        return name == null ? "_" : name;
    }

    public EPackage getEPackage(XPackage xPackage) {
        this.interpreter = (XcoreInterpreter)((Object)this.interpreterProvider.get());
        this.classLoader = this.classLoaderProvider.getClassLoader(xPackage.eResource().getResourceSet());
        if (this.classLoader != null) {
            this.interpreter.setClassLoader(this.classLoader);
        }
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.mapper.getMapping(xPackage).setEPackage(ePackage);
        this.mapper.getToXcoreMapping((EObject)ePackage).setXcoreElement(xPackage);
        this.handleAnnotations(xPackage, (EModelElement)ePackage);
        String name = xPackage.getName();
        XcoreEcoreBuilder.setQualifiedPackageName(ePackage, name);
        if (name != null) {
            if (ePackage.getNsURI() == null) {
                ePackage.setNsURI("org.eclipse.emf.ecore".equals(name) ? "http://www.eclipse.org/emf/2002/Ecore" : name);
            }
            if (ePackage.getNsPrefix() == null) {
                ePackage.setNsPrefix(ePackage.getName());
            }
        }
        EList eClassifiers = ePackage.getEClassifiers();
        for (XClassifier xClassifier : xPackage.getClassifiers()) {
            EClassifier eClassifier = this.getEClassifier(xClassifier);
            eClassifiers.add((Object)eClassifier);
        }
        for (XAnnotationDirective xAnnotationDirective : xPackage.getAnnotationDirectives()) {
            EcoreUtil.setAnnotation((EModelElement)ePackage, (String)"http://www.eclipse.org/emf/2011/Xcore", (String)xAnnotationDirective.getName(), (String)xAnnotationDirective.getSourceURI());
        }
        return ePackage;
    }

    void handleAnnotations(final XModelElement xModelElement, final EModelElement eModelElement) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)xModelElement);
        if (node != null) {
            for (ILeafNode child : node.getLeafNodes()) {
                if (!child.isHidden()) break;
                if (child.getGrammarElement() != this.xcoreGrammarAccess.getML_COMMENTRule()) continue;
                String text = child.getText();
                int length = text.length();
                if (length <= 4) break;
                String[] lines = COMMENT_LINE_BREAK_PATTERN.split(text.subSequence(2, length - 2), 0);
                StringBuilder comment = null;
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.length() != 0) {
                        if (comment == null) {
                            comment = new StringBuilder();
                            comment.append(line);
                        } else {
                            comment.append('\n');
                            comment.append(line);
                        }
                    } else if (comment != null) {
                        comment.append('\n');
                        comment.append(line);
                    }
                    ++n2;
                }
                if (comment == null) break;
                EcoreUtil.setDocumentation((EModelElement)eModelElement, (String)comment.toString());
                break;
            }
        }
        this.handleAnnotations(xModelElement, eModelElement, true);
        this.runnables.add(new Runnable(){

            public void run() {
                XcoreEcoreBuilder.this.handleAnnotations(xModelElement, eModelElement, false);
            }
        });
    }

    protected void handleAnnotations(XModelElement xModelElement, EModelElement eModelElement, boolean preIndexing) {
        EList eAnnotations = eModelElement.getEAnnotations();
        for (XAnnotation xAnnotation : xModelElement.getAnnotations()) {
            String sourceURI = null;
            if (preIndexing) {
                String simpleAnnotationName;
                List nodes = NodeModelUtils.findNodesForFeature((EObject)xAnnotation, (EStructuralFeature)XcorePackage.Literals.XANNOTATION__SOURCE);
                StringBuilder annotationLiteral = new StringBuilder();
                for (INode node : nodes) {
                    annotationLiteral.append(NodeModelUtils.getTokenText((INode)node));
                }
                int index = annotationLiteral.lastIndexOf(" ");
                if (index != -1) {
                    annotationLiteral.delete(0, index + 1);
                }
                if ((index = annotationLiteral.lastIndexOf(".")) != -1) {
                    annotationLiteral.delete(0, index + 1);
                }
                if ("GenModel".equals(simpleAnnotationName = annotationLiteral.toString())) {
                    sourceURI = "http://www.eclipse.org/emf/2002/GenModel";
                } else if ("Ecore".equals(simpleAnnotationName)) {
                    sourceURI = "http://www.eclipse.org/emf/2002/Ecore";
                } else if ("ExtendedMetaData".equals(simpleAnnotationName)) {
                    sourceURI = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
                }
            } else {
                XAnnotationDirective source = xAnnotation.getSource();
                if (source != null) {
                    sourceURI = source.getSourceURI();
                }
            }
            if (sourceURI == null) continue;
            EClass eClass = "http://www.eclipse.org/emf/2002/Ecore".equals(sourceURI) ? eModelElement.eClass() : null;
            EMap<String, String> details = xAnnotation.getDetails();
            if (details.isEmpty()) {
                EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(sourceURI);
                eAnnotations.add((Object)eAnnotation);
                continue;
            }
            for (Map.Entry detail : details) {
                EStructuralFeature eStructuralFeature;
                String key = (String)detail.getKey();
                String value = (String)detail.getValue();
                if (eClass != null && (eStructuralFeature = eClass.getEStructuralFeature(key)) instanceof EAttribute) {
                    eModelElement.eSet(eStructuralFeature, (Object)value);
                    continue;
                }
                if (EcoreUtil.getAnnotation((EModelElement)eModelElement, (String)sourceURI, (String)key) != null) continue;
                EcoreUtil.setAnnotation((EModelElement)eModelElement, (String)sourceURI, (String)key, (String)value);
            }
        }
    }

    EClassifier getEClassifier(final XClassifier xClassifier) {
        EClass eClassifier = xClassifier instanceof XClass ? this.getEClass((XClass)xClassifier) : (xClassifier instanceof XEnum ? this.getEEnum((XEnum)xClassifier) : this.getEDataType((XDataType)xClassifier));
        this.handleAnnotations(xClassifier, (EModelElement)eClassifier);
        eClassifier.setName(this.nonNullName(xClassifier.getName()));
        if (xClassifier.eIsSet((EStructuralFeature)XcorePackage.Literals.XCLASSIFIER__INSTANCE_TYPE)) {
            if (eClassifier instanceof EClass) {
                eClassifier.setInstanceTypeName("java.lang.Cloneable");
            }
            this.instanceTypeRunnables.add(new Runnable((EClassifier)eClassifier){
                private final /* synthetic */ EClassifier val$eClassifier;
                {
                    this.val$eClassifier = eClassifier;
                }

                public void run() {
                    JvmTypeReference instanceType = xClassifier.getInstanceType();
                    if (instanceType != null) {
                        String instanceTypeName = instanceType.getIdentifier();
                        String normalizedInstanceTypeName = EcoreUtil.toJavaInstanceTypeName((EGenericType)((EGenericType)EcoreValidator.EGenericTypeBuilder.INSTANCE.parseInstanceTypeName(instanceTypeName).getData().get(0)));
                        this.val$eClassifier.setInstanceTypeName(normalizedInstanceTypeName);
                        if (XcoreEcoreBuilder.this.classLoader != null && this.val$eClassifier instanceof EClassifierImpl) {
                            try {
                                Class<?> instanceClass = XcoreEcoreBuilder.this.classLoader.loadClass(this.val$eClassifier.getInstanceClassName());
                                ((EClassifierImpl)this.val$eClassifier).setInstanceClassGen(instanceClass);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
        }
        return eClassifier;
    }

    EClass getEClass(XClass xClass) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.mapper.getMapping(xClass).setEClass(eClass);
        this.mapper.getToXcoreMapping((EObject)eClass).setXcoreElement(xClass);
        if (xClass.isInterface()) {
            eClass.setInterface(true);
            eClass.setAbstract(true);
        } else if (xClass.isAbstract()) {
            eClass.setAbstract(true);
        }
        EList eGenericSuperTypes = eClass.getEGenericSuperTypes();
        for (XGenericType superType : xClass.getSuperTypes()) {
            eGenericSuperTypes.add((Object)this.getEGenericType(superType));
        }
        EList eTypeParameters = eClass.getETypeParameters();
        for (XTypeParameter xTypeParameter : xClass.getTypeParameters()) {
            ETypeParameter eTypeParameter = this.getETypeParameter(xTypeParameter);
            eTypeParameters.add((Object)eTypeParameter);
        }
        EList eOperations = eClass.getEOperations();
        EList eStructuralFeatures = eClass.getEStructuralFeatures();
        for (XMember xMember : xClass.getMembers()) {
            if (xMember instanceof XOperation) {
                EOperation eOperation = this.getEOperation((XOperation)xMember);
                eOperations.add((Object)eOperation);
                continue;
            }
            if (xMember instanceof XReference) {
                EReference eReference = this.getEReference((XReference)xMember);
                eStructuralFeatures.add((Object)eReference);
                continue;
            }
            EAttribute eAttribute = this.getEAttribute((XAttribute)xMember);
            eStructuralFeatures.add((Object)eAttribute);
        }
        return eClass;
    }

    EOperation getEOperation(XOperation xOperation) {
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        this.mapper.getMapping(xOperation).setEOperation(eOperation);
        this.mapper.getToXcoreMapping((EObject)eOperation).setXcoreElement(xOperation);
        eOperation.setUnique(false);
        this.handleETypedElement((ETypedElement)eOperation, xOperation);
        EList eTypeParameters = eOperation.getETypeParameters();
        for (XTypeParameter xTypeParameter : xOperation.getTypeParameters()) {
            Iterator eTypeParameter = this.getETypeParameter(xTypeParameter);
            eTypeParameters.add((Object)eTypeParameter);
        }
        EList eParameters = eOperation.getEParameters();
        for (XParameter xParameter : xOperation.getParameters()) {
            EParameter eParameter = this.getEParameter(xParameter);
            eParameters.add((Object)eParameter);
        }
        for (XGenericType exception : xOperation.getExceptions()) {
            EGenericType eException = this.getEGenericType(exception);
            eOperation.getEGenericExceptions().add((Object)eException);
        }
        XBlockExpression body = xOperation.getBody();
        if (body != null) {
            XcoreInvocationDelegate invocationDelegate = (XcoreInvocationDelegate)this.operationDelegateProvider.get();
            invocationDelegate.initialize(body, eOperation, this.interpreter);
            ((EOperation.Internal)eOperation).setInvocationDelegate((EOperation.Internal.InvocationDelegate)invocationDelegate);
            EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"body", (String)"");
        }
        return eOperation;
    }

    EParameter getEParameter(XParameter xParameter) {
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        this.mapper.getMapping(xParameter).setEParameter(eParameter);
        this.mapper.getToXcoreMapping((EObject)eParameter).setXcoreElement(xParameter);
        eParameter.setUnique(false);
        this.handleETypedElement((ETypedElement)eParameter, xParameter);
        return eParameter;
    }

    ETypeParameter getETypeParameter(XTypeParameter xTypeParameter) {
        ETypeParameter eTypeParameter = EcoreFactory.eINSTANCE.createETypeParameter();
        this.mapper.getMapping(xTypeParameter).setETypeParameter(eTypeParameter);
        this.mapper.getToXcoreMapping((EObject)eTypeParameter).setXcoreElement(xTypeParameter);
        this.handleAnnotations(xTypeParameter, (EModelElement)eTypeParameter);
        eTypeParameter.setName(this.nonNullName(xTypeParameter.getName()));
        EList eBounds = eTypeParameter.getEBounds();
        for (XGenericType xGenericType : xTypeParameter.getBounds()) {
            eBounds.add((Object)this.getEGenericType(xGenericType));
        }
        return eTypeParameter;
    }

    void handleETypedElement(ETypedElement eTypedElement, XTypedElement xTypedElement) {
        int[] multiplicity;
        eTypedElement.setName(this.nonNullName(xTypedElement.getName()));
        this.handleAnnotations(xTypedElement, (EModelElement)eTypedElement);
        eTypedElement.setEGenericType(this.getEGenericType(xTypedElement.getType()));
        if (xTypedElement.isUnordered()) {
            eTypedElement.setOrdered(false);
        }
        if (xTypedElement.isUnique()) {
            eTypedElement.setUnique(true);
        }
        if ((multiplicity = xTypedElement.getMultiplicity()) != null) {
            if (multiplicity.length == 0) {
                eTypedElement.setUpperBound(-1);
            } else if (multiplicity.length == 1) {
                if (multiplicity[0] != -3) {
                    if (multiplicity[0] == -2) {
                        eTypedElement.setLowerBound(1);
                        eTypedElement.setUpperBound(-1);
                    } else if (multiplicity[0] == -1) {
                        eTypedElement.setUpperBound(-1);
                    } else {
                        eTypedElement.setLowerBound(multiplicity[0]);
                        eTypedElement.setUpperBound(multiplicity[0]);
                    }
                }
            } else {
                eTypedElement.setLowerBound(multiplicity[0]);
                eTypedElement.setUpperBound(multiplicity[1]);
            }
        }
    }

    EGenericType getEGenericType(final XGenericType xGenericType) {
        XGenericType upperBound;
        if (xGenericType == null) {
            return null;
        }
        final EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        XGenericType lowerBound = xGenericType.getLowerBound();
        if (lowerBound != null) {
            eGenericType.setELowerBound(this.getEGenericType(lowerBound));
        }
        if ((upperBound = xGenericType.getUpperBound()) != null) {
            eGenericType.setEUpperBound(this.getEGenericType(upperBound));
        }
        EList eTypeArguments = eGenericType.getETypeArguments();
        for (XGenericType typeArgument : xGenericType.getTypeArguments()) {
            eTypeArguments.add((Object)this.getEGenericType(typeArgument));
        }
        this.runnables.add(new Runnable(){

            public void run() {
                GenBase type = xGenericType.getType();
                if (type instanceof GenTypeParameter) {
                    eGenericType.setETypeParameter(((GenTypeParameter)type).getEcoreTypeParameter());
                } else if (type instanceof GenClassifier) {
                    eGenericType.setEClassifier(((GenClassifier)type).getEcoreClassifier());
                }
            }
        });
        return eGenericType;
    }

    EReference getEReference(final XReference xReference) {
        final EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        this.mapper.getMapping(xReference).setEStructuralFeature((EStructuralFeature)eReference);
        this.mapper.getToXcoreMapping((EObject)eReference).setXcoreElement(xReference);
        if (xReference.isContainment()) {
            eReference.setContainment(true);
            if (!xReference.isResolveProxies()) {
                eReference.setResolveProxies(false);
            }
        }
        if (xReference.isLocal()) {
            eReference.setResolveProxies(false);
        }
        this.handleEStructuralFeature((EStructuralFeature)eReference, xReference);
        this.runnables.add(new Runnable(){

            public void run() {
                GenFeature opposite = xReference.getOpposite();
                if (opposite != null) {
                    eReference.setEOpposite((EReference)opposite.getEcoreFeature());
                }
                XcoreEcoreBuilder.this.runnables.add(new Runnable(){

                    public void run() {
                        for (GenFeature key : xReference.getKeys()) {
                            EStructuralFeature eAttribute = key.getEcoreFeature();
                            if (!(eAttribute instanceof EAttribute)) continue;
                            eReference.getEKeys().add((Object)((EAttribute)eAttribute));
                        }
                    }
                });
            }
        });
        return eReference;
    }

    EAttribute getEAttribute(XAttribute xAttribute) {
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        this.mapper.getMapping(xAttribute).setEStructuralFeature((EStructuralFeature)eAttribute);
        this.mapper.getToXcoreMapping((EObject)eAttribute).setXcoreElement(xAttribute);
        eAttribute.setUnique(false);
        if (xAttribute.isID()) {
            eAttribute.setID(true);
        }
        eAttribute.setDefaultValueLiteral(xAttribute.getDefaultValueLiteral());
        this.handleEStructuralFeature((EStructuralFeature)eAttribute, xAttribute);
        return eAttribute;
    }

    void handleEStructuralFeature(EStructuralFeature eStructuralFeature, XStructuralFeature xStructuralFeature) {
        eStructuralFeature.setName(this.nonNullName(xStructuralFeature.getName()));
        this.handleETypedElement((ETypedElement)eStructuralFeature, xStructuralFeature);
        if (xStructuralFeature.isReadonly()) {
            eStructuralFeature.setChangeable(false);
        }
        if (xStructuralFeature.isTransient()) {
            eStructuralFeature.setTransient(true);
        }
        if (xStructuralFeature.isVolatile()) {
            eStructuralFeature.setVolatile(true);
        }
        if (xStructuralFeature.isUnsettable()) {
            eStructuralFeature.setUnsettable(true);
        }
        if (xStructuralFeature.isDerived()) {
            eStructuralFeature.setDerived(true);
        }
        XBlockExpression getBody = xStructuralFeature.getGetBody();
        XBlockExpression setBody = xStructuralFeature.getSetBody();
        XBlockExpression isSetBody = xStructuralFeature.getIsSetBody();
        XBlockExpression unsetBody = xStructuralFeature.getUnsetBody();
        if (getBody != null || setBody != null || isSetBody != null || unsetBody != null) {
            XcoreSettingDelegate settingDelegate = (XcoreSettingDelegate)this.settingDelegateProvider.get();
            settingDelegate.initialize(getBody, setBody, isSetBody, unsetBody, eStructuralFeature, this.interpreter);
            ((EStructuralFeature.Internal)eStructuralFeature).setSettingDelegate((EStructuralFeature.Internal.SettingDelegate)settingDelegate);
        }
        if (getBody != null) {
            eStructuralFeature.setTransient(true);
            eStructuralFeature.setVolatile(true);
            eStructuralFeature.setDerived(true);
            if (setBody == null) {
                eStructuralFeature.setChangeable(false);
            }
        }
    }

    EDataType getEDataType(XDataType xDataType) {
        EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
        this.mapper.getMapping(xDataType).setEDataType(eDataType);
        this.mapper.getToXcoreMapping((EObject)eDataType).setXcoreElement(xDataType);
        EList eTypeParameters = eDataType.getETypeParameters();
        for (XTypeParameter xTypeParameter : xDataType.getTypeParameters()) {
            ETypeParameter eTypeParameter = this.getETypeParameter(xTypeParameter);
            eTypeParameters.add((Object)eTypeParameter);
        }
        XBlockExpression createBody = xDataType.getCreateBody();
        if (createBody != null) {
            XcoreConversionDelegate conversionDelegate = (XcoreConversionDelegate)this.conversionDelegateProvider.get();
            conversionDelegate.initialize(createBody, xDataType.getConvertBody(), eDataType, this.interpreter);
            ((EDataType.Internal)eDataType).setConversionDelegate((EDataType.Internal.ConversionDelegate)conversionDelegate);
        }
        return eDataType;
    }

    EEnum getEEnum(XEnum xEnum) {
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        this.mapper.getMapping(xEnum).setEDataType((EDataType)eEnum);
        this.mapper.getToXcoreMapping((EObject)eEnum).setXcoreElement(xEnum);
        EList eLiterals = eEnum.getELiterals();
        for (XEnumLiteral xEnumLiteral : xEnum.getLiterals()) {
            eLiterals.add((Object)this.getEEnumLiteral(xEnumLiteral));
        }
        return eEnum;
    }

    EEnumLiteral getEEnumLiteral(XEnumLiteral xEnumLiteral) {
        EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        this.mapper.getToXcoreMapping((EObject)eEnumLiteral).setXcoreElement(xEnumLiteral);
        this.mapper.getMapping(xEnumLiteral).setEEnumLiteral(eEnumLiteral);
        this.handleAnnotations(xEnumLiteral, (EModelElement)eEnumLiteral);
        eEnumLiteral.setName(this.nonNullName(xEnumLiteral.getName()));
        eEnumLiteral.setLiteral(xEnumLiteral.getLiteral());
        eEnumLiteral.setValue(xEnumLiteral.getValue());
        return eEnumLiteral;
    }
}

