/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.masterdetails;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.ui.editors.pages.EEFDetailsPage;
import org.eclipse.emf.eef.runtime.ui.layout.EEFFormLayoutFactory;
import org.eclipse.emf.eef.runtime.ui.notify.OpenWizardOnDoubleClick;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.AbstractEEFMasterPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEEFMasterDetailsBlock
extends MasterDetailsBlock {
    protected FormToolkit toolkit;
    protected AbstractEEFMasterPart masterPart;
    protected EditingDomain editingDomain;
    private AdapterFactory adapterFactory;
    protected ValidateAction validateAction;
    private EEFDetailsPage lastDetailsPage;
    private boolean orientable = true;
    private boolean showValidateAction = true;

    public AbstractEEFMasterDetailsBlock() {
    }

    public AbstractEEFMasterDetailsBlock(boolean isOrientable, boolean showValidationAction) {
        this();
        this.orientable = isOrientable;
        this.showValidateAction = showValidationAction;
    }

    protected final void createMasterPart(IManagedForm managedForm, Composite parent) {
        this.toolkit = managedForm.getToolkit();
        Composite masterContainer = managedForm.getToolkit().createComposite(parent);
        masterContainer.setLayout((Layout)EEFFormLayoutFactory.createMasterGridLayout(false, 1));
        masterContainer.setLayoutData((Object)new GridData(1808));
        this.masterPart = this.createEEFMasterPart(masterContainer);
        managedForm.addPart((IFormPart)this.masterPart);
        Section section = this.masterPart.getSection();
        section.setLayout((Layout)EEFFormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(1808));
        this.masterPart.getModelViewer().addDoubleClickListener((IDoubleClickListener)new OpenWizardOnDoubleClick(this.editingDomain, this.getAdapterFactory()));
        if (this.showValidateAction) {
            this.masterPart.addSelectionChangeListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        AbstractEEFMasterDetailsBlock.this.validateAction.updateSelection((IStructuredSelection)selection);
                    }
                }
            });
        }
    }

    protected abstract AbstractEEFMasterPart createEEFMasterPart(Composite var1);

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        if (this.showValidateAction) {
            this.validateAction = new ValidateAction();
            this.validateAction.setToolTipText(EEFRuntimeUIMessages.AbstractEEFMasterDetailsBlock_validate_action_tooltip);
            this.validateAction.setImageDescriptor(EEFRuntimePlugin.getImageDescriptor((String)"icons/16x16/validate.gif"));
            form.getToolBarManager().add((IAction)this.validateAction);
        }
        if (this.orientable) {
            Action haction = new Action("hor", 8){

                public void run() {
                    AbstractEEFMasterDetailsBlock.this.sashForm.setOrientation(256);
                    form.reflow(true);
                }
            };
            haction.setChecked(true);
            haction.setToolTipText(EEFRuntimeUIMessages.AbstractEEFMasterDetailsBlock_horizontal_layout);
            haction.setImageDescriptor(EEFRuntimePlugin.getImageDescriptor((String)"icons/16x16/th_horizontal.gif"));
            haction.setDisabledImageDescriptor(EEFRuntimePlugin.getImageDescriptor((String)"icons/16x16/disabled/th_horizontal.gif"));
            form.getToolBarManager().add((IAction)haction);
            Action vaction = new Action("ver", 8){

                public void run() {
                    AbstractEEFMasterDetailsBlock.this.sashForm.setOrientation(512);
                    form.reflow(true);
                }
            };
            vaction.setChecked(false);
            vaction.setToolTipText(EEFRuntimeUIMessages.AbstractEEFMasterDetailsBlock_vertical_layout);
            vaction.setImageDescriptor(EEFRuntimePlugin.getImageDescriptor((String)"icons/16x16/th_vertical.gif"));
            vaction.setDisabledImageDescriptor(EEFRuntimePlugin.getImageDescriptor((String)"icons/16x16/disabled/th_vertical.gif"));
            form.getToolBarManager().add((IAction)vaction);
        }
        if (this.additionalPageActions() != null) {
            for (Action additionalAction : this.additionalPageActions()) {
                form.getToolBarManager().add((IAction)additionalAction);
            }
        }
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider(new IDetailsPageProvider(){

            public Object getPageKey(Object object) {
                if (object instanceof EObject) {
                    return EObject.class;
                }
                return object.getClass();
            }

            public IDetailsPage getPage(Object key) {
                if (key.equals(EObject.class)) {
                    AbstractEEFMasterDetailsBlock.this.lastDetailsPage = new EEFDetailsPage(AbstractEEFMasterDetailsBlock.this.toolkit, AbstractEEFMasterDetailsBlock.this.editingDomain, AbstractEEFMasterDetailsBlock.this.adapterFactory);
                    return AbstractEEFMasterDetailsBlock.this.lastDetailsPage;
                }
                return null;
            }
        });
    }

    public AbstractEEFMasterPart getMasterPart() {
        return this.masterPart;
    }

    public EEFDetailsPage getLastDetailsPage() {
        return this.lastDetailsPage;
    }

    public void setOrientation(int orientation) {
        this.sashForm.setOrientation(orientation);
    }

    public AdapterFactory getAdapterFactory() {
        return this.masterPart.getAdapterFactory();
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.masterPart.setAdapterFactory(adapterFactory);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void setInput(Object input) {
        this.masterPart.setInput(input);
    }

    public void addFilter(ViewerFilter filter) {
        this.masterPart.addFilter(filter);
    }

    protected List<Action> additionalPageActions() {
        return null;
    }
}

