/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.actions;

import java.util.Collection;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.emf.facet.infra.browser.editors.EcoreBrowser;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.ui.actions.AbstractLoadFacetsAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFacetsAction
extends AbstractLoadFacetsAction {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public LoadFacetsAction(IBrowserActionBarContributor browserActionBarContributor) {
        this.browserActionBarContributor = browserActionBarContributor;
    }

    protected void loadFacet(Facet facetToLoad) {
        this.browserActionBarContributor.getBrowser().getBrowserConfiguration().getAppearanceConfiguration().loadFacet(facetToLoad);
    }

    protected void clearFacets() {
        this.browserActionBarContributor.getBrowser().getBrowserConfiguration().getAppearanceConfiguration().clearFacets();
    }

    protected Collection<? extends Facet> getLoadedFacets() {
        return this.browserActionBarContributor.getBrowser().getBrowserConfiguration().getAppearanceConfiguration().getLoadedFacets();
    }

    protected Collection<EPackage> getReferencedEPackages() {
        return this.browserActionBarContributor.getBrowser().getReferencedEPackages();
    }

    protected void facetsLoaded(Collection<Facet> facets) {
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (facets.size() > 0) {
            browser.getBrowserConfiguration().getAppearanceConfiguration().getCustomizationEngine().loadCustomizations();
        }
        browser.getBrowserConfiguration().getInstancesForMetaclasses().buildDerivationTree();
        browser.getBrowserConfiguration().getAppearanceConfiguration().touch();
        browser.refreshDelayed(true);
    }
}

