/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.editors.table;

import org.eclipse.emf.facet.infra.browser.Messages;
import org.eclipse.emf.facet.infra.browser.editors.table.ITableEditor;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TableEditorToolBar {
    private static final int HEIGHT = 25;
    private final ITableEditor tableEditor;
    private final ToolBar toolBar;
    private final Label label;
    private ToolItem btnSortColumnsByType;
    private ToolItem btnHideEmptyColumns;
    private ToolItem btnOnlyShowCommonColumns;

    public TableEditorToolBar(final Composite parent, ITableEditor tableEditor) {
        this.tableEditor = tableEditor;
        this.addLinePainter(parent);
        GridData treeToolBarGridData = new GridData();
        treeToolBarGridData.grabExcessHorizontalSpace = true;
        treeToolBarGridData.horizontalAlignment = 4;
        treeToolBarGridData.heightHint = 25;
        parent.setLayoutData((Object)treeToolBarGridData);
        this.label = new Label(parent, 0);
        this.toolBar = new ToolBar(parent, 0);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point toolbarSize = TableEditorToolBar.this.toolBar.computeSize(-1, -1);
                TableEditorToolBar.this.toolBar.setSize(toolbarSize);
                int splitPoint = parent.getSize().x - toolbarSize.x;
                TableEditorToolBar.this.toolBar.setLocation(splitPoint, 0);
                TableEditorToolBar.this.label.setLocation(3, 5);
                TableEditorToolBar.this.label.setSize(splitPoint - 6, parent.getSize().y - 7);
            }
        });
        this.createToolButtons();
        this.initialize();
    }

    private void addLinePainter(Composite composite) {
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(Display.getDefault().getSystemColor(15));
                e.gc.drawLine(0, e.height - 1, e.width, e.height - 1);
            }
        });
    }

    private void createToolButtons() {
        this.btnSortColumnsByType = new ToolItem(this.toolBar, 32);
        this.btnSortColumnsByType.setToolTipText(Messages.TableEditorToolBar_tooltip_sortColumnsByType);
        this.btnSortColumnsByType.setImage(ImageProvider.getInstance().getSortLinksByTypeIcon());
        this.btnSortColumnsByType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditorToolBar.this.tableEditor.setSortColumnsByType(TableEditorToolBar.this.btnSortColumnsByType.getSelection());
            }
        });
        this.btnHideEmptyColumns = new ToolItem(this.toolBar, 32);
        this.btnHideEmptyColumns.setToolTipText(Messages.TableEditorToolBar_tooltip_HideEmtpyColumns);
        this.btnHideEmptyColumns.setImage(ImageProvider.getInstance().getHideEmptyColumnsIcon());
        this.btnHideEmptyColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditorToolBar.this.tableEditor.setHideEmptyColumns(TableEditorToolBar.this.btnHideEmptyColumns.getSelection());
            }
        });
        this.btnOnlyShowCommonColumns = new ToolItem(this.toolBar, 32);
        this.btnOnlyShowCommonColumns.setToolTipText(Messages.TableEditorToolBar_tooltip_OnlyShowCommonColumns);
        this.btnOnlyShowCommonColumns.setImage(ImageProvider.getInstance().getCommonColumnsIcon());
        this.btnOnlyShowCommonColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditorToolBar.this.tableEditor.setOnlyShowCommonColumns(TableEditorToolBar.this.btnOnlyShowCommonColumns.getSelection());
            }
        });
    }

    private void initialize() {
        this.btnHideEmptyColumns.setSelection(false);
        this.btnOnlyShowCommonColumns.setSelection(false);
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }
}

