/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grégoire Dupé (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.common.core.internal.protocol;

import java.util.HashMap;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;

/**
 * This class offers methods to get the description of the EmfFacet sub-protocol
 * registered through the org.eclipse.emf.facet.common.core.protocolext
 * extension point.
 * 
 * @author Grégoire Dupé (Mia-Software)
 * @see EmfFacetResourceFactoryImpl
 */
public final class EmfFacetProtocolExtensionRegistry {

	private static final String EXTENTION_POINT_ID = "org.eclipse.emf.facet.common.core.protocolext"; //$NON-NLS-1$
	private static HashMap<String, IEmfFacetProtocolExtension> factoryExtMap = initMap();

	/**
	 * This must not be instantiated
	 */
	private EmfFacetProtocolExtensionRegistry() {
		// Nothing to do
	}

	private static HashMap<String, IEmfFacetProtocolExtension> initMap() {
		HashMap<String, IEmfFacetProtocolExtension> localFactoryExtMap = new HashMap<String, IEmfFacetProtocolExtension>();
		IConfigurationElement[] configs = Platform.getExtensionRegistry()
				.getConfigurationElementsFor(EmfFacetProtocolExtensionRegistry.EXTENTION_POINT_ID);
		for (IConfigurationElement config : configs) {
			try {
				IEmfFacetProtocolExtension emffacetProtocolExtension = (IEmfFacetProtocolExtension) config
						.createExecutableExtension("class"); //$NON-NLS-1$
				localFactoryExtMap.put(emffacetProtocolExtension.getSchemeSpecificPart(),
						emffacetProtocolExtension);
			} catch (Exception e) {
				IStatus status = new Status(IStatus.ERROR, CommonEmfFacetActivator.PLUGIN_ID,
						"Failed to load " //$NON-NLS-1$
								+ IEmfFacetProtocolExtension.class.getSimpleName() + " for: " //$NON-NLS-1$
								+ config.getNamespaceIdentifier(), e);
				CommonEmfFacetActivator.getDefault().getLog().log(status);
			}
		}
		return localFactoryExtMap;
	}

	/**
	 * 
	 * @return the map pointing to the class implementing
	 *         IEmfFacetProtocolExtension for each registered EmfFacet
	 *         sub-protocol
	 */
	public static HashMap<String, IEmfFacetProtocolExtension> getFactoryExtMap() {
		return EmfFacetProtocolExtensionRegistry.factoryExtMap;
	}

}