/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.java.ui.internal.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.query.java.core.internal.exceptions.ClassAlreadyExistsException;
import org.eclipse.emf.facet.query.java.core.internal.exceptions.ResourceURIExpectedException;
import org.eclipse.emf.facet.query.java.ui.internal.Activator;
import org.eclipse.emf.facet.query.java.ui.internal.Messages;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.page.NewQueryClassWizardPage;
import org.eclipse.emf.facet.query.java.ui.internal.wizard.page.SelectOrCreateJavaClassWizardPage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;

public class SelectOrCreateJavaClassWizard
extends Wizard {
    private final FacetSet facetSet;
    private final String facetName;
    private EClassifier eType = null;
    private int upperBound = 0;
    private EClassifier scope = null;
    private NewQueryClassWizardPage newQueryClassWizardPage;
    private boolean createFileOnFinish = true;
    private WizardDialog dialog;
    private SelectOrCreateJavaClassWizardPage selectOrCreatePage;
    private boolean userChoice = false;

    public SelectOrCreateJavaClassWizard(FacetSet facetSet, String facetName, boolean createFileOnFinish) throws ClassAlreadyExistsException, ResourceURIExpectedException, JavaModelException {
        String implementationClassName;
        this.facetSet = facetSet;
        this.facetName = facetName;
        this.createFileOnFinish = createFileOnFinish;
        this.setWindowTitle(Messages.Choose_an_operation);
        this.dialog = new WizardDialog(this.getShell(), (IWizard)this);
        Resource resource = facetSet.eResource();
        URI uri = resource.getURI();
        if (!uri.isPlatformResource()) {
            throw new ResourceURIExpectedException();
        }
        String projectName = uri.segment(1);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.findType(implementationClassName = String.valueOf(this.facetName) + "Query") != null) {
            throw new ClassAlreadyExistsException();
        }
    }

    public void addPages() {
        this.selectOrCreatePage = new SelectOrCreateJavaClassWizardPage();
        this.addPage((IWizardPage)this.selectOrCreatePage);
        this.newQueryClassWizardPage = new NewQueryClassWizardPage();
        this.addPage(this.newQueryClassWizardPage);
        this.newQueryClassWizardPage.init(this.facetSet, this.facetName, this.eType);
    }

    public void createJavaClass() {
        this.newQueryClassWizardPage.apply(this.eType, this.upperBound, this.scope);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.selectOrCreatePage) {
            return this.selectOrCreatePage.canFinish();
        }
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    public boolean isSelectExistingJavaClass() {
        return this.userChoice;
    }

    public boolean performFinish() {
        try {
            if (this.createFileOnFinish && this.getContainer().getCurrentPage() == this.newQueryClassWizardPage) {
                this.createJavaClass();
            } else {
                this.userChoice = this.getContainer().getCurrentPage() != this.newQueryClassWizardPage;
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return false;
        }
        return true;
    }

    public void setEType(EClassifier eType) {
        this.eType = eType;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public void setScope(EClassifier scope) {
        this.scope = scope;
    }

    public int open() {
        if (this.dialog != null) {
            return this.dialog.open();
        }
        return 1;
    }

    public String getImplementationClassName() {
        return String.valueOf(this.newQueryClassWizardPage.getPackageFragment().getElementName()) + "." + this.newQueryClassWizardPage.getTypeName();
    }
}

