/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.ocl.sdk.ui.internal.widget.oclexpression;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.facet.query.ocl.core.util.OclQueryUtil;
import org.eclipse.emf.facet.query.ocl.sdk.ui.internal.Messages;
import org.eclipse.emf.facet.query.ocl.sdk.ui.widget.oclexpression.IOCLExpressionWidget;
import org.eclipse.emf.facet.util.ui.internal.exported.util.widget.AbstractWidget;
import org.eclipse.emf.facet.util.ui.utils.PropertyElement;
import org.eclipse.ocl.ParserException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class OclExpressionWidgetSimple
extends AbstractWidget
implements IOCLExpressionWidget {
    private static final String UNREC_VAR = "Unrecognized variable";
    private static final int TEXT_HEIGHT = 100;
    private final EClassifier context;
    private final String expression;
    private Text text;
    private final PropertyElement oclExpressionProp;

    public OclExpressionWidgetSimple(Composite parent, EClassifier context, String expression, PropertyElement oclExpressionProp) {
        super(parent);
        this.context = context;
        this.expression = expression;
        this.setLayoutData(new GridData(768));
        this.oclExpressionProp = oclExpressionProp;
    }

    protected void addSubWidgets() {
        this.text = new Text((Composite)this, 514);
        GridData gridData = new GridData(768);
        gridData.heightHint = 100;
        this.text.setLayoutData((Object)gridData);
        if (this.expression != null) {
            this.text.setText(this.expression);
        }
    }

    public String getError() {
        String result = null;
        String textExpression = this.text.getText().trim();
        if ("".equals(textExpression)) {
            result = Messages.OclExpression_Error;
        } else {
            try {
                OclQueryUtil.createOCLExpression((EClassifier)this.context, (String)textExpression);
                this.oclExpressionProp.setValue((Object)textExpression);
            }
            catch (ParserException exception) {
                if (exception.getMessage().contains(UNREC_VAR)) {
                    this.oclExpressionProp.setValue((Object)textExpression);
                }
                result = String.valueOf(Messages.OclExpression_Error) + " :\n - " + exception.getMessage();
            }
        }
        return result;
    }

    public void notifyChanged() {
    }

    public void setExpression(String expression) {
        this.text.setText(expression);
    }
}

