/*******************************************************************************
 * Copyright (c) 2010, 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 337454 - We can't delete a query Column
 *    Nicolas Guyomar (Mia-Software) - Bug 339922 - INatTableWidget method isCellSelected should use the plural
 *    Nicolas Guyomar (Mia-Software) - Bug 340886 - NPE in handlers
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.handlers;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class DeleteHandler extends AbstractHandler {

	private List<INatTableWidgetProvider> alreadyListenedPart = new ArrayList<INatTableWidgetProvider>();

	public Object execute(final ExecutionEvent event) throws ExecutionException {
		IWorkbenchPart activePart = HandlerUtil.getActivePart(event);
		if (activePart != null) {
			INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider) activePart
					.getAdapter(INatTableWidgetProvider.class);
			if (natTableWidgetPart != null) {
				natTableWidgetPart.getNatTableWidget().deleteSelection();
			}
		}
		return null;
	}

	@Override
	public boolean isEnabled() {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (window != null) {
			IWorkbenchPage page = window.getActivePage();
			if (page != null) {
				IWorkbenchPart activePart = page.getActivePart();
				if (activePart != null) {
					final INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider) activePart
							.getAdapter(INatTableWidgetProvider.class);
					if (natTableWidgetPart != null) {
						if (activePart instanceof ISelectionProvider
								&& !this.alreadyListenedPart.contains(natTableWidgetPart)) {
							ISelectionProvider iWorkbenchPartProvider = (ISelectionProvider) activePart;
							iWorkbenchPartProvider
									.addSelectionChangedListener(new ISelectionChangedListener() {
										public void selectionChanged(final SelectionChangedEvent event) {
											setBaseEnabled(natTableWidgetPart.getNatTableWidget()
													.isCellsDeletable() || natTableWidgetPart.getNatTableWidget().isSelectedColumnDeletable());
										}
									});
							this.alreadyListenedPart.add(natTableWidgetPart);
						}
						return natTableWidgetPart.getNatTableWidget().isCellsDeletable()
								|| natTableWidgetPart.getNatTableWidget().isSelectedColumnDeletable();
					}
				}
			}
		}
		return false;
	}
}
