/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class DefaultSizeUtils {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private static final int MARGIN = 4;
    private static final int FONT_CELL_RATIO = 2;
    private static final int WIDTH_HEIGHT_RATIO = 8;
    private static final int ROW_HEADER_RATIO = 2;
    private static final int DEFAULT_DPI = 96;

    private DefaultSizeUtils() {
    }

    public static int getDefaultCellHeight() {
        int dpiX = Display.getDefault().getDPI().x;
        int dpiY = Display.getDefault().getDPI().y;
        FontData[] fd = Display.getDefault().getSystemFont().getFontData();
        fd[0].getName();
        int height = fd[0].getHeight() * 2 + 4;
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellHeight: fd[0].getHeight()=" + fd[0].getHeight());
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellHeight: height=" + height);
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellHeight: dpi x=" + dpiX);
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellHeight: dpi y=" + dpiY);
        }
        return height * (dpiY / 96);
    }

    public static int getDefaultCellWidth() {
        int width = DefaultSizeUtils.getDefaultCellHeight() * 8;
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellWidth: " + width);
        }
        return width;
    }

    public static int getDefaultRowHeaderWidth() {
        int width = DefaultSizeUtils.getDefaultCellHeight() * 2;
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultRowHeaderWidth: " + width);
        }
        return width;
    }

    public static Font getHeaderFont() {
        FontData[] fd = (FontData[])Display.getDefault().getSystemFont().getFontData().clone();
        fd[0].setStyle(1);
        Font headerFont = new Font((Device)Display.getDefault(), fd);
        return headerFont;
    }
}

