/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.util.HashMap;
import org.eclipse.equinox.internal.transforms.ProxyStreamTransformer;
import org.eclipse.equinox.internal.transforms.StreamTransformer;
import org.eclipse.equinox.internal.transforms.TransformerHook;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class TransformerList
extends ServiceTracker {
    private volatile boolean stale = true;
    private HashMap transformers = new HashMap();

    public TransformerList(BundleContext context) throws InvalidSyntaxException {
        super(context, context.createFilter("(&(objectClass=" + Object.class.getName() + ")(" + "equinox.transformerType" + "=*))"), null);
        this.open();
    }

    public synchronized StreamTransformer getTransformer(String type) {
        if (this.stale) {
            this.rebuildTransformersMap();
        }
        return (StreamTransformer)this.transformers.get(type);
    }

    public synchronized boolean hasTransformers() {
        if (this.stale) {
            this.rebuildTransformersMap();
        }
        return this.transformers.size() > 0;
    }

    private void rebuildTransformersMap() {
        this.transformers.clear();
        ServiceReference[] serviceReferences = this.getServiceReferences();
        this.stale = false;
        if (serviceReferences == null) {
            return;
        }
        int i = 0;
        while (i < serviceReferences.length) {
            ServiceReference serviceReference = serviceReferences[i];
            String type = serviceReference.getProperty("equinox.transformerType").toString();
            if (type != null && this.transformers.get(type) == null) {
                Object object = this.getService(serviceReference);
                if (object instanceof StreamTransformer) {
                    this.transformers.put(type, object);
                } else {
                    try {
                        ProxyStreamTransformer transformer = new ProxyStreamTransformer(object);
                        this.transformers.put(type, transformer);
                    }
                    catch (SecurityException e) {
                        TransformerHook.log(4, "Problem creating transformer", e);
                    }
                    catch (NoSuchMethodException e) {
                        TransformerHook.log(4, "Problem creating transformer", e);
                    }
                }
            }
            ++i;
        }
    }

    public Object addingService(ServiceReference reference) {
        try {
            Object object = super.addingService(reference);
            return object;
        }
        finally {
            this.stale = true;
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        super.modifiedService(reference, service);
        this.stale = true;
    }

    public void removedService(ServiceReference reference, Object service) {
        super.removedService(reference, service);
        this.stale = true;
    }
}

