/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.aspectj.weaver.IUnwovenClassFile;
import org.aspectj.weaver.bcel.BcelWeakClassLoaderReference;
import org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingStarter;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiWeavingAdaptor
extends ClassLoaderWeavingAdaptor {
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(ClassLoaderWeavingAdaptor.class);
    private final ClassLoader classLoader;
    private Method defineClassMethod;
    private boolean initialized;
    private final Object initializeLock = new Object();
    private final String namespace;
    private final OSGiWeavingContext weavingContext;

    public OSGiWeavingAdaptor(ClassLoader loader, OSGiWeavingContext context, String namespace) {
        this.classLoader = loader;
        this.weavingContext = context;
        this.namespace = namespace;
    }

    private void defineClass(ClassLoader loader, String name, byte[] bytes) {
        if (trace.isTraceEnabled()) {
            trace.enter("defineClass", (Object)this, new Object[]{loader, name, bytes});
        }
        Object clazz = null;
        this.debug("generating class '" + name + "'");
        try {
            if (this.defineClassMethod == null) {
                this.defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, bytes.getClass(), Integer.TYPE, Integer.TYPE);
            }
            this.defineClassMethod.setAccessible(true);
            clazz = this.defineClassMethod.invoke((Object)loader, name, bytes, new Integer(0), new Integer(bytes.length));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof LinkageError) {
                this.warn("define generated class failed", e.getTargetException());
            } else {
                this.warn("define generated class failed", e.getTargetException());
            }
        }
        catch (Exception e) {
            this.warn("define generated class failed", e);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("defineClass", clazz);
        }
    }

    public Map<String, byte[]> getGeneratedClassesFor(String className) {
        Map generated = this.generatedClasses;
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (String name : generated.keySet()) {
            IUnwovenClassFile unwovenClass = (IUnwovenClassFile)generated.get(name);
            if (className.equals(name)) continue;
            result.put(name, unwovenClass.getBytes());
        }
        this.flushGeneratedClasses();
        return result;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.initializeLock;
        synchronized (object) {
            if (!this.initialized) {
                super.initialize(this.classLoader, (IWeavingContext)this.weavingContext);
                this.generatedClassHandler = new OSGiGeneratedClassHandler(this.classLoader);
                this.initialized = true;
                if (AspectJWeavingStarter.verbose) {
                    if (this.isEnabled()) {
                        System.err.println("[org.eclipse.equinox.weaving.aspectj] info weaving bundle '" + this.weavingContext.getClassLoaderName() + "'");
                    } else {
                        System.err.println("[org.eclipse.equinox.weaving.aspectj] info not weaving bundle '" + this.weavingContext.getClassLoaderName() + "'");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] weaveClass(String name, byte[] bytes, boolean mustWeave) throws IOException {
        Object object = this.initializeLock;
        synchronized (object) {
            if (!this.initialized) {
                super.initialize(this.classLoader, (IWeavingContext)this.weavingContext);
                this.generatedClassHandler = new OSGiGeneratedClassHandler(this.classLoader);
                this.initialized = true;
            }
        }
        object = this;
        synchronized (object) {
            bytes = super.weaveClass(name, bytes, mustWeave);
        }
        ((OSGiGeneratedClassHandler)this.generatedClassHandler).defineGeneratedClasses();
        return bytes;
    }

    class GeneratedClass {
        private final byte[] bytes;
        private final String name;

        public GeneratedClass(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String getName() {
            return this.name;
        }
    }

    class OSGiGeneratedClassHandler
    implements GeneratedClassHandler {
        private final ConcurrentLinkedQueue<GeneratedClass> classesToBeDefined;
        private final BcelWeakClassLoaderReference loaderRef;

        public OSGiGeneratedClassHandler(ClassLoader loader) {
            this.loaderRef = new BcelWeakClassLoaderReference(loader);
            this.classesToBeDefined = new ConcurrentLinkedQueue();
        }

        public void acceptClass(String name, byte[] bytes) {
            try {
                if (OSGiWeavingAdaptor.this.shouldDump(name.replace('/', '.'), false)) {
                    OSGiWeavingAdaptor.this.dump(name, bytes, false);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.classesToBeDefined.offer(new GeneratedClass(name, bytes));
        }

        public void acceptClass(String name, byte[] originalBytes, byte[] weavedBytes) {
            this.acceptClass(name, weavedBytes);
        }

        public void defineGeneratedClasses() {
            while (!this.classesToBeDefined.isEmpty()) {
                GeneratedClass generatedClass = this.classesToBeDefined.poll();
                if (generatedClass == null) break;
                OSGiWeavingAdaptor.this.defineClass(this.loaderRef.getClassLoader(), generatedClass.getName(), generatedClass.getBytes());
            }
        }
    }
}

