/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.mm.chess.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.graphiti.examples.mm.chess.Board;
import org.eclipse.graphiti.examples.mm.chess.ChessFactory;
import org.eclipse.graphiti.examples.mm.chess.ChessPackage;
import org.eclipse.graphiti.examples.mm.chess.Colors;
import org.eclipse.graphiti.examples.mm.chess.Files;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Ranks;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.examples.mm.chess.Types;
import org.eclipse.graphiti.examples.mm.chess.impl.BoardImpl;
import org.eclipse.graphiti.examples.mm.chess.impl.PieceImpl;
import org.eclipse.graphiti.examples.mm.chess.impl.SquareImpl;

public class ChessFactoryImpl
extends EFactoryImpl
implements ChessFactory {
    public static ChessFactory init() {
        try {
            ChessFactory theChessFactory = (ChessFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/graphiti/examples/chess");
            if (theChessFactory != null) {
                return theChessFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ChessFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBoard();
            }
            case 1: {
                return this.createSquare();
            }
            case 2: {
                return this.createPiece();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createRanksFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createFilesFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createColorsFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createTypesFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertRanksToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertFilesToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertColorsToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertTypesToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Board createBoard() {
        BoardImpl board = new BoardImpl();
        return board;
    }

    public Square createSquare() {
        SquareImpl square = new SquareImpl();
        return square;
    }

    public Piece createPiece() {
        PieceImpl piece = new PieceImpl();
        return piece;
    }

    public Ranks createRanksFromString(EDataType eDataType, String initialValue) {
        Ranks result = Ranks.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRanksToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Files createFilesFromString(EDataType eDataType, String initialValue) {
        Files result = Files.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFilesToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Colors createColorsFromString(EDataType eDataType, String initialValue) {
        Colors result = Colors.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertColorsToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Types createTypesFromString(EDataType eDataType, String initialValue) {
        Types result = Types.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTypesToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ChessPackage getChessPackage() {
        return (ChessPackage)this.getEPackage();
    }

    @Deprecated
    public static ChessPackage getPackage() {
        return ChessPackage.eINSTANCE;
    }
}

