/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.examples.tutorial.TutorialUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.AbstractDrillDownFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialDrillDownEClassFeature
extends AbstractDrillDownFeature {
    public TutorialDrillDownEClassFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Open associated diagram";
    }

    public String getDescription() {
        return "Open the diagram associated with this EClass";
    }

    public boolean canExecute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof EClass) {
            return super.canExecute(context);
        }
        return false;
    }

    protected Collection<Diagram> getDiagrams() {
        Collection<Diagram> result = Collections.emptyList();
        Resource resource = this.getDiagram().eResource();
        URI uri = resource.getURI();
        URI uriTrimmed = uri.trimFragment();
        if (uriTrimmed.isPlatformResource()) {
            String platformString = uriTrimmed.toPlatformString(true);
            IResource fileResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            if (fileResource != null) {
                IProject project = fileResource.getProject();
                result = TutorialUtil.getDiagrams(project);
            }
        }
        return result;
    }
}

