/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationGroup;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationItem;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.osgi.service.prefs.BackingStoreException;

public final class ApplicationBrowserContentProvider
implements ITreeContentProvider {
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ApplicationGroup) {
            return ((ApplicationGroup)parentElement).getChildren().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ApplicationManager) {
            ApplicationManager appManager = (ApplicationManager)inputElement;
            HashMap<IRuntimeContext, ApplicationGroup> treeItems = new HashMap<IRuntimeContext, ApplicationGroup>();
            try {
                TreeSet registeredApplications = new TreeSet(appManager.getRegisteredApplications());
                for (String appId : registeredApplications) {
                    ApplicationRegistration applicationRegistration = appManager.getApplicationRegistration(appId);
                    IRuntimeContext groupObject = applicationRegistration.getContext();
                    ApplicationGroup treeGroup = (ApplicationGroup)treeItems.get(groupObject);
                    if (treeGroup == null) {
                        treeGroup = new ApplicationGroup(groupObject, inputElement);
                        treeItems.put(treeGroup.getValue(), treeGroup);
                    }
                    IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
                    TreeSet<String> mounts = new TreeSet<String>();
                    try {
                        String[] urls;
                        String[] stringArray = urls = urlsNode.keys();
                        int n = urls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String url = stringArray[n2];
                            if (appId.equals(urlsNode.get(url, ""))) {
                                mounts.add(url);
                            }
                            ++n2;
                        }
                    }
                    catch (BackingStoreException e) {
                        mounts.add(e.getMessage());
                    }
                    ApplicationProviderRegistration applicationProviderRegistration = (ApplicationProviderRegistration)HttpActivator.getInstance().getProviderRegistry().getRegisteredProviders().get(applicationRegistration.getProviderId());
                    ApplicationItem item = new ApplicationItem(applicationRegistration, applicationProviderRegistration, appManager.isActive(appId), mounts);
                    treeGroup.addChild(item);
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            return treeItems.values().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ApplicationItem) {
            return ((ApplicationItem)element).getParent();
        }
        if (element instanceof ApplicationGroup) {
            return ((ApplicationItem)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ApplicationGroup;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

