/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.jobs.configuration.wizard.JobConfigurationWizardAdapter;
import org.eclipse.gyrex.admin.ui.jobs.configuration.wizard.JobConfigurationWizardSession;
import org.eclipse.gyrex.admin.ui.jobs.internal.ExclusiveLockWizardPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.ScheduleEntryWizardPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.generic.GenericJobParameterPage;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleEntryWizard
extends Wizard {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleEntryWizard.class);
    private static final IWizardPage[] NO_PAGES = new IWizardPage[0];
    private final Map<String, JobConfigurationWizardSession> sessionsByJobTypeId = new HashMap<String, JobConfigurationWizardSession>(2);
    private final ScheduleImpl schedule;
    private final ScheduleEntryImpl entry;
    private final ScheduleEntryWizardPage scheduleEntryPage;
    private JobConfigurationWizardSession currentSession;
    private final ExclusiveLockWizardPage exclusiveLockPage;

    public ScheduleEntryWizard(ScheduleImpl schedule, ScheduleEntryImpl entry) {
        this.schedule = schedule;
        this.entry = entry;
        this.scheduleEntryPage = new ScheduleEntryWizardPage(schedule, entry);
        this.exclusiveLockPage = new ExclusiveLockWizardPage(schedule, entry);
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.scheduleEntryPage);
        this.addPage((IWizardPage)this.exclusiveLockPage);
    }

    public boolean canFinish() {
        return this.scheduleEntryPage.isPageComplete() && this.exclusiveLockPage.isPageComplete() && this.currentSession != null && this.currentSession.canFinish();
    }

    void clearCurrentJobConfigurationSession() {
        this.currentSession = null;
        this.getContainer().showPage((IWizardPage)this.scheduleEntryPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] sessionPages;
        IWizardPage[] iWizardPageArray = sessionPages = this.currentSession != null ? this.currentSession.getPages() : NO_PAGES;
        if (page == this.scheduleEntryPage) {
            if (sessionPages.length > 0) {
                return sessionPages[0];
            }
            return this.exclusiveLockPage;
        }
        if (page == this.exclusiveLockPage) {
            return null;
        }
        int i = 0;
        while (i < sessionPages.length) {
            if (page == sessionPages[i]) {
                if (i + 1 < sessionPages.length) {
                    return sessionPages[i + 1];
                }
                return this.exclusiveLockPage;
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] sessionPages;
        IWizardPage[] iWizardPageArray = sessionPages = this.currentSession != null ? this.currentSession.getPages() : NO_PAGES;
        if (page == this.exclusiveLockPage) {
            if (sessionPages.length > 0) {
                return sessionPages[sessionPages.length - 1];
            }
            return this.scheduleEntryPage;
        }
        if (page == this.scheduleEntryPage) {
            return null;
        }
        int i = sessionPages.length - 1;
        while (i >= 0) {
            if (page == sessionPages[i]) {
                if (i - 1 >= 0) {
                    return sessionPages[i - 1];
                }
                return this.scheduleEntryPage;
            }
            --i;
        }
        return null;
    }

    public ScheduleImpl getSchedule() {
        return this.schedule;
    }

    public ScheduleEntryImpl getScheduleEntry() {
        return this.entry;
    }

    void initializeCurrentJobConfigurationSession(String id, String name, JobConfigurationWizardAdapter wizardAdapter) {
        JobConfigurationWizardSession session;
        if (!this.sessionsByJobTypeId.containsKey(id)) {
            session = new JobConfigurationWizardSession(id, name);
            if (this.entry != null) {
                session.getParameter().putAll(this.entry.getJobParameter());
            }
            this.sessionsByJobTypeId.put(id, session);
        }
        if ((session = this.sessionsByJobTypeId.get(id)) == this.currentSession) {
            return;
        }
        if (session.getPages() == null) {
            IWizardPage[] iWizardPageArray;
            if (wizardAdapter != null) {
                iWizardPageArray = wizardAdapter.createPages(session);
            } else {
                IWizardPage[] iWizardPageArray2 = new IWizardPage[1];
                iWizardPageArray = iWizardPageArray2;
                iWizardPageArray2[0] = new GenericJobParameterPage(session);
            }
            IWizardPage[] pages = iWizardPageArray;
            if (pages != null) {
                session.setPages(pages);
                IWizardPage[] iWizardPageArray3 = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray3[n2];
                    this.addPage(page);
                    ++n2;
                }
            } else {
                LOG.debug("No pages returned for job type {} (adapter {})", (Object)id, (Object)wizardAdapter);
                session.setPages(NO_PAGES);
            }
        }
        this.currentSession = session;
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public boolean performFinish() {
        String entryId = this.scheduleEntryPage.getEntryId();
        ScheduleEntryImpl entry = null;
        try {
            if (this.entry == null) {
                entry = this.schedule.createEntry(entryId);
                entry.setJobTypeId(this.scheduleEntryPage.getJobTypeId());
            } else {
                entry = this.entry;
            }
            if (this.scheduleEntryPage.isScheduleUsingCronExpression()) {
                entry.setCronExpression(this.scheduleEntryPage.getCronExpression());
            } else {
                entry.setCronExpression(null);
            }
            if (this.scheduleEntryPage.isScheduleUsingPreceedingEntries()) {
                entry.setPrecedingEntries(this.scheduleEntryPage.getPreceedingEntryIds());
            } else {
                entry.setPrecedingEntries(new String[0]);
            }
            HashMap<String, String> parameter = new HashMap<String, String>(this.currentSession.getParameter());
            if (IdHelper.isValidId((String)this.exclusiveLockPage.getLockId())) {
                parameter.put("gyrex.jobs.lockId", this.exclusiveLockPage.getLockId());
            }
            entry.setJobParameter(parameter);
            this.schedule.save();
            return true;
        }
        catch (AssertionError | Exception | LinkageError e) {
            if (entry != this.entry) {
                this.schedule.removeEntry(entryId);
            }
            LOG.debug("Error saving schedule. ", (Throwable)e);
            NonBlockingMessageDialogs.openError((Shell)this.getShell(), (String)"Error Saving Schedule", (String)("Unable to save schedule. " + ((Throwable)e).getMessage()), null);
            return false;
        }
    }
}

