/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiActivator;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.definitions.IRuntimeContextDefinitionManager;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SchedulesContentProvider
implements ITreeContentProvider {
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ContextDefinition) {
            return this.getSchedules(((ContextDefinition)parentElement).getPath());
        }
        return EMPTY_ARRAY;
    }

    private IRuntimeContext getContext(IPath contextPath) {
        return ((IRuntimeContextRegistry)JobsUiActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(contextPath);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IRuntimeContextDefinitionManager) {
            IRuntimeContextDefinitionManager contextRegistry = (IRuntimeContextDefinitionManager)inputElement;
            List definedContexts = contextRegistry.getDefinedContexts();
            ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>(definedContexts.size());
            for (ContextDefinition contextDefinition : definedContexts) {
                if (!this.hasSchedules(contextDefinition.getPath())) continue;
                result.add(contextDefinition);
            }
            return result.toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    private Object[] getSchedules(IPath contextPath) {
        try {
            IRuntimeContext context = this.getContext(contextPath);
            if (context == null) {
                return EMPTY_ARRAY;
            }
            IScheduleManager scheduleManager = (IScheduleManager)context.get(IScheduleManager.class);
            if (scheduleManager == null) {
                return EMPTY_ARRAY;
            }
            Collection scheduleIds = scheduleManager.getSchedules();
            ArrayList<ISchedule> schedules = new ArrayList<ISchedule>(scheduleIds.size());
            for (String id : scheduleIds) {
                ISchedule schedule = scheduleManager.getSchedule(id);
                if (schedule == null) continue;
                schedules.add(schedule);
            }
            return schedules.toArray();
        }
        catch (Exception e) {
            Object[] errorresponse = new String[]{e.getMessage()};
            return errorresponse;
        }
    }

    public boolean hasChildren(Object element) {
        return element instanceof ContextDefinition && this.hasSchedules(((ContextDefinition)element).getPath());
    }

    private boolean hasSchedules(IPath contextPath) {
        IScheduleManager scheduleManager;
        block5: {
            IRuntimeContext context;
            block4: {
                try {
                    context = this.getContext(contextPath);
                    if (context != null) break block4;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            scheduleManager = (IScheduleManager)context.get(IScheduleManager.class);
            if (scheduleManager != null) break block5;
            return false;
        }
        return !scheduleManager.getSchedules().isEmpty();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

