/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import java.net.URI;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.gyrex.admin.ui.internal.widgets.FilteredItemsSelectionDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiActivator;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiDebug;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.p2.internal.repositories.RepoUtil;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredIUSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FilteredIUSelectionDialog.class);
    private Button fShowLatestVersionOnlyButton;
    private boolean fShowLatestVersionOnly = true;
    private final IQuery<IInstallableUnit> query;
    private final ILabelProvider fLabelProvider = new P2UiLabelProvider();

    public FilteredIUSelectionDialog(Shell shell, IQuery<IInstallableUnit> query) {
        super(shell, true);
        this.query = query;
        this.setTitle("Add Artifact to Software Package");
        this.setMessage("&Select an artifact to add to your software package (? = any character, * = any string):");
        this.setListLabelProvider(this.fLabelProvider);
        this.setDetailsLabelProvider(this.fLabelProvider);
        new SynchReposJob().schedule();
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fShowLatestVersionOnlyButton = new Button(composite, 32);
        this.fShowLatestVersionOnlyButton.setSelection(true);
        this.fShowLatestVersionOnlyButton.setText("Show latest version only");
        this.fShowLatestVersionOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                FilteredIUSelectionDialog.this.fShowLatestVersionOnly = FilteredIUSelectionDialog.this.fShowLatestVersionOnlyButton.getSelection();
                FilteredIUSelectionDialog.this.applyFilter();
            }
        });
        return composite;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new IUItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IProvisioningAgent agent = ((IProvisioningAgentProvider)P2UiActivator.getInstance().getService(IProvisioningAgentProvider.class)).createAgent(null);
        if (agent == null) {
            String message = "The current system has not been provisioned using p2. Unable to acquire provisioning agent.";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.p2", "The current system has not been provisioned using p2. Unable to acquire provisioning agent."));
        }
        try {
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            if (manager == null) {
                String message = "The provision system is broken. Unable to acquire metadata repository service.";
                throw new CoreException((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.p2", "The provision system is broken. Unable to acquire metadata repository service."));
            }
            IQuery pipedQuery = this.fShowLatestVersionOnly ? QueryUtil.createPipeQuery(this.query, (IQuery)QueryUtil.createLatestIUQuery()) : this.query;
            if (P2UiDebug.debug) {
                LOG.debug("Performing search...");
            }
            for (IInstallableUnit iu : manager.query(pipedQuery, progressMonitor)) {
                if (P2UiDebug.debug) {
                    LOG.debug("Found IU: {}", (Object)iu);
                }
                contentProvider.add((Object)iu, itemsFilter);
            }
        }
        finally {
            if (agent != null) {
                agent.stop();
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("org.eclipse.gyrex.admin.ui.p2.internal.FilteredIUSelectionDialog");
    }

    public String getElementName(Object item) {
        return null;
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                String id1 = null;
                String id2 = null;
                if (!(o1 instanceof IInstallableUnit)) {
                    return 0;
                }
                id1 = ((IInstallableUnit)o1).getId();
                if (!(o2 instanceof IInstallableUnit)) {
                    return 0;
                }
                id2 = ((IInstallableUnit)o2).getId();
                return id1.compareTo(id2);
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    class IUItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        boolean latest;

        public IUItemsFilter() {
            super((FilteredItemsSelectionDialog)FilteredIUSelectionDialog.this);
            this.latest = false;
            this.latest = FilteredIUSelectionDialog.this.fShowLatestVersionOnly;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter obj) {
            if (this.latest != ((IUItemsFilter)obj).latest) {
                return false;
            }
            return super.equals(obj);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean isIUMatch(IInstallableUnit iu) {
            if (iu.getFragments() != null && iu.getFragments().size() > 0) {
                return false;
            }
            String id = iu.getId();
            if (StringUtils.endsWith((String)id, (String)".source") || StringUtils.endsWith((String)id, (String)".source.feature.group")) {
                return false;
            }
            String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
            if (name == null || name.startsWith("%")) {
                name = "";
            }
            return this.patternMatcher.matches(id) || this.patternMatcher.matches(name);
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (this.latest != ((IUItemsFilter)filter).latest) {
                return false;
            }
            return super.isSubFilter(filter);
        }

        public boolean matchItem(Object item) {
            if (item instanceof IInstallableUnit) {
                return this.isIUMatch((IInstallableUnit)item);
            }
            return false;
        }
    }

    private static final class SynchReposJob
    extends Job {
        private SynchReposJob() {
            super("Synchronizing Repositories");
            this.setSystem(false);
            this.setPriority(30);
        }

        protected IStatus run(IProgressMonitor progressMonitor) {
            IProvisioningAgent agent = null;
            try {
                agent = ((IProvisioningAgentProvider)P2UiActivator.getInstance().getService(IProvisioningAgentProvider.class)).createAgent(null);
                if (agent == null) {
                    LOG.warn("The current system has not been provisioned using p2. Unable to acquire provisioning agent.");
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                if (manager == null) {
                    LOG.warn("The provision system is broken. Unable to acquire metadata repository service.");
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    RepoUtil.configureRepositories((IMetadataRepositoryManager)manager, (IArtifactRepositoryManager)((IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME)));
                    URI[] knownRepositories = manager.getKnownRepositories(2);
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)knownRepositories.length);
                    URI[] uRIArray = knownRepositories;
                    int n = knownRepositories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URI uri = uRIArray[n2];
                        if (P2UiDebug.debug) {
                            LOG.debug("Loading repository {}...", (Object)uri);
                        }
                        manager.loadRepository(uri, (IProgressMonitor)monitor.newChild(1));
                        ++n2;
                    }
                }
                catch (ProvisionException e) {
                    LOG.warn("Error synchronizing repositories. {}", (Object)e.getMessage());
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
            finally {
                if (agent != null) {
                    agent.stop();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

