/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import java.net.URI;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.gyrex.admin.ui.p2.internal.Node;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiImages;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.PackageManager;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class P2UiLabelProvider
extends LabelProvider {
    private static final long serialVersionUID = 1L;
    private ResourceManager manager;

    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
        super.dispose();
    }

    private String getElementText(IInstallableUnit iu) {
        StringBuilder label = new StringBuilder();
        String name = iu.getProperty("org.eclipse.equinox.p2.name", Locale.getDefault().toString());
        if (StringUtils.isNotBlank((String)name)) {
            label.append(name).append(" - ");
        }
        label.append(iu.getId());
        return label.toString();
    }

    private String getElementText(InstallableUnitReference unit) {
        StringBuilder label = new StringBuilder();
        label.append(unit.getId());
        Version version = unit.getVersion();
        if (version != null) {
            label.append(" (").append(version.toString()).append(")");
        }
        return label.toString();
    }

    private String getElementText(IProfile profile) {
        String name = profile.getProperty("org.eclipse.equinox.p2.name");
        if (name != null && name.length() > 0) {
            return name;
        }
        return profile.getProfileId();
    }

    private String getElementText(IRepository<?> repository) {
        String name = repository.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return URIUtil.toUnencodedString((URI)repository.getLocation());
    }

    private String getElementText(PackageDefinition pkg) {
        StringBuilder label = new StringBuilder();
        label.append(pkg.getId());
        PackageManager packageManager = P2Activator.getInstance().getPackageManager();
        if (packageManager.isMarkedForInstall(pkg)) {
            label.append(" (provisioned)");
        }
        if (packageManager.isMarkedForUninstall(pkg)) {
            label.append(" (revoked)");
        }
        return label.toString();
    }

    private String getElementText(RepositoryDefinition repo) {
        StringBuilder label = new StringBuilder();
        label.append(repo.getId());
        label.append(" (");
        label.append(repo.getLocation());
        label.append(") ");
        return label.toString();
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = this.getImageDescriptor(element);
        if (descriptor == null) {
            if (element instanceof IArtifactKey) {
                descriptor = P2UiImages.getImageDescriptor("obj/artifact_key.gif");
            } else {
                return null;
            }
        }
        return this.getResourceManager().createImage(descriptor);
    }

    private ImageDescriptor getImageDescriptor(Object element) {
        if (element instanceof IProfile) {
            return P2UiImages.getImageDescriptor("obj/profile_obj.gif");
        }
        if (element instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)element;
            if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.type.patch")).booleanValue()) {
                return P2UiImages.getImageDescriptor("obj/iu_patch_obj.gif");
            }
            if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.type.category")).booleanValue()) {
                return P2UiImages.getImageDescriptor("obj/category_obj.gif");
            }
            return P2UiImages.getImageDescriptor("obj/iu_obj.gif");
        }
        if (element instanceof IArtifactRepository) {
            return P2UiImages.getImageDescriptor("obj/artifact_repo_obj.gif");
        }
        if (element instanceof IMetadataRepository) {
            return P2UiImages.getImageDescriptor("obj/metadata_repo_obj.gif");
        }
        if (element instanceof IRequirement) {
            return P2UiImages.getImageDescriptor("obj/iu_obj.gif");
        }
        return null;
    }

    private ResourceManager getResourceManager() {
        if (this.manager == null) {
            this.manager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.manager;
    }

    public String getText(Object element) {
        if (element instanceof PackageDefinition) {
            return this.getElementText((PackageDefinition)element);
        }
        if (element instanceof RepositoryDefinition) {
            return this.getElementText((RepositoryDefinition)element);
        }
        if (element instanceof InstallableUnitReference) {
            return this.getElementText((InstallableUnitReference)element);
        }
        if (element instanceof IProfile) {
            return this.getElementText((IProfile)element);
        }
        if (element instanceof IInstallableUnit) {
            return this.getElementText((IInstallableUnit)element);
        }
        if (element instanceof IRepository) {
            return this.getElementText((IRepository)element);
        }
        if (element instanceof IArtifactKey) {
            IArtifactKey key = (IArtifactKey)element;
            return String.valueOf(key.getId()) + " [" + key.getClassifier() + "]";
        }
        if (element instanceof IProcessingStepDescriptor) {
            IProcessingStepDescriptor descriptor = (IProcessingStepDescriptor)element;
            return descriptor.getProcessorId();
        }
        if (element instanceof Node) {
            Node node = (Node)element;
            StringBuilder label = new StringBuilder();
            label.append(node.getId());
            return label.toString();
        }
        return super.getText(element);
    }
}

