/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.CharSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperNodeInfo;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class NodeInfo {
    private static final String NODE_ID_FILENAME = "nodeId";
    private static final CharSet ALLOWED_NODE_ID_CHARS = CharSet.getInstance((String[])new String[]{"a-z", "0-9", ".", "-", "_"});
    private static final AtomicReference<String> verifiedNodeId = new AtomicReference();
    private final String nodeId = NodeInfo.initializeNodeId();
    private final boolean approved;
    private final String location;
    private final String name;
    private final Set<String> tags;
    private final int version;

    private static String generateNodeId() {
        try {
            return String.valueOf(InetAddress.getLocalHost().getHostName().toLowerCase()) + "_" + Integer.toHexString(Platform.getInstanceLocation().toString().hashCode());
        }
        catch (Exception exception) {
            return UUID.randomUUID().toString();
        }
    }

    private static String getDefaultLocationInfo(String nodeId) {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return String.valueOf(nodeId) + ": " + e.getMessage();
        }
    }

    private static File getNodeIdFile() {
        return Platform.getStateLocation((Bundle)CloudActivator.getInstance().getBundle()).append(NODE_ID_FILENAME).toFile();
    }

    private static String initializeNodeId() {
        try {
            String rawNodeId;
            String nodeId = verifiedNodeId.get();
            if (nodeId != null) {
                return nodeId;
            }
            File nodeIdFile = NodeInfo.getNodeIdFile();
            if (nodeIdFile.exists() && nodeIdFile.isFile() && NodeInfo.isValidNodeId(rawNodeId = StringUtils.trimToNull((String)FileUtils.readFileToString((File)nodeIdFile, (String)"US-ASCII")))) {
                verifiedNodeId.compareAndSet(null, rawNodeId);
                return verifiedNodeId.get();
            }
            String newNodeId = NodeInfo.generateNodeId();
            if (verifiedNodeId.compareAndSet(null, newNodeId)) {
                FileUtils.writeStringToFile((File)nodeIdFile, (String)newNodeId, (String)"US-ASCII");
            }
            return verifiedNodeId.get();
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)"Unable to initialize node id. {0}", (Object)e.getMessage()), e);
        }
    }

    private static boolean isValidNodeId(String rawNodeId) {
        if (StringUtils.isBlank((String)rawNodeId)) {
            return false;
        }
        char[] cArray = rawNodeId.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!ALLOWED_NODE_ID_CHARS.contains(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public NodeInfo() {
        this.location = NodeInfo.getDefaultLocationInfo(this.nodeId);
        this.name = null;
        this.tags = Collections.emptySet();
        this.approved = false;
        this.version = -1;
    }

    NodeInfo(ZooKeeperNodeInfo info) throws Exception {
        if (!this.nodeId.equals(info.getId())) {
            throw new IllegalArgumentException("node id mismatch");
        }
        if (!info.isApproved()) {
            throw new IllegalArgumentException("node must be approved first");
        }
        this.approved = info.isApproved();
        this.version = info.getVersion();
        this.name = info.getName();
        this.location = info.getLocation() != null ? info.getLocation() : NodeInfo.getDefaultLocationInfo(this.nodeId);
        Set<String> tags = info.getTags();
        this.tags = tags != null ? Collections.unmodifiableSet(tags) : Collections.emptySet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInfo other = (NodeInfo)obj;
        if (this.approved != other.approved) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return this.version == other.version;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name != null ? this.name : this.nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.approved ? 1231 : 1237);
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public String toString() {
        StrBuilder info = new StrBuilder();
        info.append(this.getName()).append(" (");
        info.append(this.location);
        info.append(", ");
        info.append(this.approved ? "APPROVED" : "PENDING");
        info.append(", ");
        info.append(this.nodeId);
        info.append(" v");
        info.append(this.version);
        info.append(")");
        return info.toString();
    }
}

