/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;

public class ZooKeeperNodeInfo {
    private static final String PROP_TAGS = "tags";
    private static final String PROP_LOCATION = "location";
    private static final String PROP_NAME = "name";
    private final String nodeId;
    private final int version;
    private final boolean approved;
    private String name;
    private String location;
    private Set<String> tags;

    public static void approve(String nodeId, String name, String location) throws Exception {
        ZooKeeperGate zk = ZooKeeperGate.get();
        try {
            ZooKeeperNodeInfo info = ZooKeeperNodeInfo.load(nodeId, false);
            if (name == null) {
                name = info.getName();
            }
            if (location == null) {
                location = info.getLocation();
            }
        }
        catch (Exception exception) {}
        ZooKeeperNodeInfo nodeInfo = new ZooKeeperNodeInfo(nodeId, true, null, 0);
        nodeInfo.setName(name);
        nodeInfo.setLocation(location);
        zk.createPath(IZooKeeperLayout.PATH_NODES_APPROVED.append(nodeId), CreateMode.PERSISTENT, nodeInfo.toByteArray());
        zk.deletePath(IZooKeeperLayout.PATH_NODES_PENDING.append(nodeId));
    }

    public static ZooKeeperNodeInfo load(String nodeId, boolean approved) throws IllegalStateException {
        Stat stat = new Stat();
        IPath path = approved ? IZooKeeperLayout.PATH_NODES_APPROVED : IZooKeeperLayout.PATH_NODES_PENDING;
        byte[] record = null;
        try {
            record = ZooKeeperGate.get().readRecord(path.append(nodeId), stat);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            throw new IllegalStateException(String.format(approved ? "Approved record for node %s not found!" : "Pending record for node %s not found!", nodeId));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to read record for node %s! %s", nodeId, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
        return new ZooKeeperNodeInfo(nodeId, approved, record, stat.getVersion());
    }

    public static void save(ZooKeeperNodeInfo info, boolean approved) throws IllegalStateException {
        IPath path = approved ? IZooKeeperLayout.PATH_NODES_APPROVED : IZooKeeperLayout.PATH_NODES_PENDING;
        try {
            ZooKeeperGate.get().writeRecord(path.append(info.getId()), CreateMode.PERSISTENT, info.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to save record for node %s! %s", info.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    public ZooKeeperNodeInfo(String nodeId, boolean approved, byte[] data, int version) {
        if (nodeId == null) {
            throw new IllegalArgumentException("node id must not be null");
        }
        this.nodeId = nodeId;
        this.approved = approved;
        this.version = version;
        Properties properties = new Properties();
        if (data != null) {
            try {
                properties.load(new ByteArrayInputStream(data));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Invalid node data for node %s. %s", nodeId, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
            }
        }
        this.name = properties.getProperty(PROP_NAME);
        this.location = properties.getProperty(PROP_LOCATION, null);
        String[] tags = StringUtils.split((String)properties.getProperty(PROP_TAGS), (char)',');
        if (tags != null && tags.length > 0) {
            HashSet<String> cloudTags = new HashSet<String>(tags.length);
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (!cloudTags.contains(role)) {
                    cloudTags.add(role);
                }
                ++n2;
            }
            this.tags = cloudTags;
        }
    }

    public String getId() {
        return this.nodeId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    private byte[] toByteArray() throws IOException {
        Properties nodeData = new Properties();
        if (StringUtils.isNotBlank((String)this.name)) {
            nodeData.setProperty(PROP_NAME, this.name);
        }
        if (StringUtils.isNotBlank((String)this.location)) {
            nodeData.setProperty(PROP_LOCATION, this.location);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            nodeData.setProperty(PROP_TAGS, StringUtils.join(this.tags, (char)','));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        nodeData.store(out, null);
        return out.toByteArray();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_FIELD_NAMES_STYLE).append("id", (Object)this.nodeId).append(PROP_NAME, (Object)this.name).append(PROP_LOCATION, (Object)this.location).append(PROP_TAGS, this.tags).toString();
    }
}

